<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko 10kg Washing Machine Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko 10kg Washing Machine Manual</h1>
<p>The Beko 10kg Washing Machine is a high-capacity front-loading appliance designed for efficient home laundry. It features multiple wash programs, energy-saving technologies, a user-friendly digital display, child lock, delay start, and various fabric-specific cycles. Below are key sections covering safety, features, installation, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water & Drain</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Special Functions</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section11">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: 10kg drum capacity, Digital Display, Program Selector Knob, Start/Pause button, Delay Start, Child Lock, Quick Wash, Spin Speed Adjustment.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>10kg Capacity</td><td>Handles large laundry loads efficiently</td></tr>
<tr><td>Digital Display</td><td>Shows time, program, and status</td></tr>
<tr><td>Program Selector Knob</td><td>Selects from multiple wash programs</td></tr>
<tr><td>Start/Pause Button</td><td>Starts or pauses the wash cycle</td></tr>
<tr><td>Delay Start</td><td>Delays cycle start up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Locks controls to prevent accidental changes</td></tr>
<tr><td>Quick Wash</td><td>30-minute cycle for lightly soiled items</td></tr>
<tr><td>Spin Speed Adjustment</td><td>Adjusts spin speed for different fabrics</td></tr>
<tr><td>Energy Rating</td><td>High energy efficiency class</td></tr>
<tr><td>Water Inlet</td><td>Hot & cold water connections</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on level, stable floor.</p>
<ol>
<li>Remove transit bolts: Use spanner to remove bolts at rear; keep for future moves.</li>
<li>Connect water supply: Attach hoses to hot/cold taps; ensure tight connections.</li>
<li>Connect drain hose: Place in standpipe or sink; secure to avoid slipping.</li>
<li>Level the machine: Adjust feet until machine is stable and does not rock.</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in wet areas. Ensure water connections are leak-free before use.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first wash, run a maintenance cycle.</p>
<ol>
<li>Remove packaging materials from drum and door seal.</li>
<li>Connect power and water; turn on taps.</li>
<li>Run empty hot wash with detergent to clean interior.</li>
<li>Set language if available via control panel.</li>
<li>Familiarize with program descriptions in manual.</li>
</ol>
<p><strong>CAUTION!</strong> Do not overload. Sort laundry by color and fabric type.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Capacity:</strong> 10 kg (dry weight).</li>
<li><strong>Energy Class:</strong> A+++ (or as per model).</li>
<li><strong>Spin Speed:</strong> Up to 1400 rpm (adjustable).</li>
<li><strong>Programs:</strong> Cotton, Synthetic, Delicate, Wool, Quick Wash, Rinse & Spin, etc.</li>
<li><strong>Dimensions (HxWxD):</strong> Approx. 85cm x 60cm x 60cm.</li>
<li><strong>Water Pressure:</strong> 0.5 - 10 bar.</li>
<li><strong>Power Supply:</strong> 220-240V, 50Hz.</li>
<li><strong>Noise Level:</strong> Wash: < 55 dB; Spin: < 75 dB.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: Program Knob, Display, Start/Pause, Delay, Child Lock, Spin Speed, Temperature.</p>
<p><strong>Program Selection:</strong> Turn knob to desired program (Cotton, Synthetics, Delicates, etc.).</p>
<p>Adjustable Settings: Temperature (cold to 90°C), Spin Speed (0-1400 rpm), Delay Start (1-24h). Special Functions: Extra Rinse, Pre-wash, Speed Wash, Silent Mode. Child Lock: Press and hold specific buttons to lock/unlock.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water & Drain</h2>
<p>Water Inlet: Connect hoses to taps (blue for cold, red for hot). Drain: Place hose in standpipe (max height 1m).</p>
<ol>
<li>Ensure taps are off before connecting hoses.</li>
<li>Use only supplied hoses; do not overtighten.</li>
<li>Secure drain hose to avoid movement during spin.</li>
<li>Check for leaks after connections.</li>
</ol>
<p><strong>Tip:</strong> Install a drip tray if machine is on wooden floor.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Select program based on fabric type and soil level.</p>
<ol>
<li>Sort laundry: Separate colors, fabrics, and delicate items.</li>
<li>Load drum: Do not exceed 10kg; distribute evenly.</li>
<li>Add detergent: Use drawer compartments (I: pre-wash, II: main wash, *: softener).</li>
<li>Select program: Turn knob (e.g., Cotton for towels/bedding).</li>
<li>Adjust settings: Temperature, spin speed, extra options.</li>
<li>Start: Press Start/Pause; display shows remaining time.</li>
<li>Pause/Stop: Press to pause; turn knob to reset.</li>
<li>Unload promptly after cycle to prevent wrinkles.</li>
</ol>
<p><strong>WARNING!</strong> Do not wash waterproof items (e.g., raincoats). Remove objects from pockets.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Special Functions</h2>
<p>Delay Start: Set delay (1-24h) to finish at desired time. Child Lock: Enable to prevent changes during cycle. Quick Wash: 30-min cycle for small, lightly soiled loads. Extra Rinse: Adds rinse for sensitive skin. Silent Mode: Reduces noise during night operation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Regular maintenance ensures longevity.</p>
<ol>
<li>Clean detergent drawer: Remove and rinse monthly.</li>
<li>Clean door seal: Wipe to remove lint and residue.</li>
<li>Run maintenance wash: Monthly hot cycle without laundry.</li>
<li>Clean filter: Locate at front bottom; turn counterclockwise to remove and clear debris.</li>
<li>Exterior: Wipe with damp cloth; unplug first.</li>
</ol>
<p><strong>CAUTION!</strong> Never use abrasive cleaners. Keep area around machine dry.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>Complies with EU directives for safety and electromagnetic compatibility. Energy label as per EU regulations. Waste disposal: Contact local authorities for recycling. For support, visit www.beko.com or contact customer service.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Power/child lock/door</td><td>Check power; ensure door closed; disable child lock.</td></tr>
<tr><td>No water intake</td><td>Taps/hoses/filter</td><td>Open taps; check hose kinks; clean inlet filter.</td></tr>
<tr><td>Water leakage</td><td>Loose connections</td><td>Tighten hoses; check door seal; ensure drain hose secure.</td></tr>
<tr><td>Excessive vibration</td><td>Transit bolts/leveling</td><td>Remove transit bolts; adjust feet to level machine.</td></tr>
<tr><td>Poor washing results</td><td>Overload/detergent</td><td>Reduce load; use correct detergent amount; select proper program.</td></tr>
<tr><td>Noisy operation</td><td>Foreign objects</td><td>Check for coins/objects in drum; ensure machine is level.</td></tr>
<tr><td>Error codes on display</td><td>Various faults</td><td>Refer to manual error code list; reset by unplugging for 5 min.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes to reset electronic control.</p>
<p><strong>Service:</strong> Contact authorized Beko service center. Do not attempt repairs yourself.</p>
<div style="text-align: center;">
Beko 10kg Washing Machine Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
