<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko 5kg Washing Machine Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko 5kg Washing Machine Manual</h1>
<p>The Beko 5kg Washing Machine is a front-loading, energy-efficient appliance designed for household laundry. It features multiple wash programs, a 5kg capacity, spin speeds up to 1200 RPM, delay timer, child lock, quick wash option, and energy-saving modes. This manual covers safety instructions, installation, program selection, daily use, maintenance, and troubleshooting to ensure optimal performance and longevity.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water & Drain</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Front-loading drum, electronic control panel, detergent drawer, filter, drain hose, and power cord.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Capacity</td><td>5kg (dry laundry weight)</td></tr>
<tr><td>Spin Speed</td><td>Up to 1200 RPM (adjustable)</td></tr>
<tr><td>Energy Class</td><td>A+++ (energy efficient)</td></tr>
<tr><td>Programs</td><td>Cotton, Synthetic, Quick Wash, Delicate, Wool, etc.</td></tr>
<tr><td>Delay Timer</td><td>Up to 24 hours delay start</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Display</td><td>LED digital display with time remaining</td></tr>
<tr><td>Door Lock</td><td>Automatic during operation</td></tr>
<tr><td>Water Inlet</td><td>Cold & hot water connections</td></tr>
<tr><td>Noise Level</td><td>Low noise operation (approx. 50-70 dB)</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on a level, solid floor.</p>
<ol>
<li>Remove transit bolts: Use wrench to remove bolts at rear; keep for future moves.</li>
<li>Connect water supply: Attach inlet hoses to cold/hot water taps (if applicable).</li>
<li>Connect drain hose: Place in standpipe or sink (max height 100 cm).</li>
<li>Level the machine: Adjust feet to ensure stability; use spirit level.</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in wet areas. Ensure transit bolts are removed before first use to prevent damage.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first wash, run a maintenance cycle.</p>
<ol>
<li>Power on: Plug in and press power button.</li>
<li>Run empty wash: Select Cotton program at 90°C without laundry to clean drum.</li>
<li>Set preferences: Use settings menu to adjust beep volume, default spin speed, etc.</li>
<li>Load detergent: Fill detergent drawer compartments as per instructions.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure water connections are tight to prevent leaks. Check drain hose is not kinked.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model Type:</strong> Front-loading automatic washer.</li>
<li><strong>Capacity:</strong> 5 kg.</li>
<li><strong>Max Spin Speed:</strong> 1200 RPM.</li>
<li><strong>Programs:</strong> 15+ programs including Eco, Quick, Delicate.</li>
<li><strong>Water Pressure:</strong> 0.5-10 bar (recommended).</li>
<li><strong>Power Supply:</strong> 220-240V, 50Hz.</li>
<li><strong>Dimensions (HxWxD):</strong> Approx. 85 x 60 x 55 cm.</li>
<li><strong>Weight:</strong> Approx. 65 kg.</li>
<li><strong>Energy Consumption:</strong> 0.85 kWh per cycle (Cotton 60°C).</li>
<li><strong>Noise (wash/spin):</strong> 56/74 dB.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: POWER, PROGRAM SELECTOR, START/PAUSE, OPTION buttons (e.g., Extra Rinse, Pre-wash), SPIN SPEED, TEMPERATURE, DELAY START.</p>
<p><strong>Display Icons:</strong> Door lock, child lock, spin, temperature, time remaining, program phase.</p>
<p>Programs: Cotton (40°C-90°C), Synthetic (30°C-60°C), Quick Wash (30 min), Delicate, Wool, Hand Wash, Rinse+Spin, Drain Only. Settings: Adjust spin speed (0-1200 RPM), temperature (cold to 90°C), delay start (1-24h). Child Lock: Press and hold specific buttons for 3 seconds to activate/deactivate.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water & Drain</h2>
<p>Water Inlet: Connect hoses to taps (blue for cold, red for hot if dual inlet). Drain: Secure hose to standpipe or sink.</p>
<ol>
<li>Turn off water taps before connecting hoses.</li>
<li>Use supplied hoses; do not reuse old ones.</li>
<li>Ensure drain hose is not submerged (to prevent siphoning).</li>
<li>Check for leaks after first connection.</li>
</ol>
<p><strong>Tip:</strong> Install a drip tray if placing on wooden floors. Use hose clips for secure connections.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Follow load guidelines: Do not exceed 5kg dry weight.</p>
<ol>
<li>Sort laundry: By color, fabric type, and soil level.</li>
<li>Load machine: Distribute evenly; do not overload.</li>
<li>Add detergent: Use drawer compartments I (pre-wash), II (main wash), * (softener).</li>
<li>Select program: Turn selector knob to desired program.</li>
<li>Adjust options: Set temperature, spin speed, extra rinse if needed.</li>
<li>Start: Press START/PAUSE; door locks automatically.</li>
<li>After wash: Remove laundry promptly; leave door ajar to dry drum.</li>
</ol>
<p><strong>WARNING!</strong> Do not open door during wash; wait until unlock symbol disappears. Remove coins/objects from pockets.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Child Lock: Locks control panel. Door Lock: Automatically engages during operation. Overflow Protection: Stops water if level is too high. Imbalance Control: Reduces spin speed if load is uneven. Thermal Cut-out: Prevents overheating.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Monthly maintenance: Clean detergent drawer, door seal, and filter.</p>
<ol>
<li>Detergent drawer: Remove and rinse under warm water.</li>
<li>Door seal: Wipe with damp cloth to remove lint/residue.</li>
<li>Filter: Locate at front bottom; turn counterclockwise to remove; clean under running water.</li>
<li>Drum: Run empty hot wash (90°C) with washing machine cleaner monthly.</li>
</ol>
<p><strong>CAUTION!</strong> Unplug before cleaning. Do not use abrasive cleaners on surfaces.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked; complies with EU directives for safety and electromagnetic compatibility. Energy label: A+++. Manufactured under ISO 9001 quality standards. For support, visit www.beko.com or contact local service center. Disposal: Follow WEEE regulations; do not dispose with household waste.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Power/door</td><td>Check plug; ensure door is closed properly; press START.</td></tr>
<tr><td>No water intake</td><td>Taps/hoses/filter</td><td>Open water taps; check hose for kinks; clean inlet filter.</td></tr>
<tr><td>Water leakage</td><td>Hoses/connections</td><td>Tighten hose connections; check drain hose position.</td></tr>
<tr><td>Excessive vibration</td><td>Transit bolts/leveling</td><td>Ensure transit bolts removed; re-level machine; redistribute load.</td></tr>
<tr><td>Poor washing results</td><td>Detergent/loading</td><td>Use correct detergent amount; do not overload; select proper program.</td></tr>
<tr><td>Error codes (e.g., E01)</td><td>Various faults</td><td>Consult manual error code list; unplug for 5 mins then retry.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart. For persistent errors, contact service.</p>
<p><strong>Service:</strong> Check warranty card; contact authorized Beko service center.</p>
<div style="text-align: center;">
Beko 5kg Washing Machine Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
