<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko 6kg Washing Machine Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko 6kg Washing Machine Manual</h1>
<p>The Beko 6kg Washing Machine is a front-loading appliance designed for efficient home laundry. It features a 6kg capacity, multiple wash programs, energy-saving options, child lock, delay start, and various spin speed settings. This manual covers safety instructions, installation, daily use, program selection, maintenance, and troubleshooting for optimal performance.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water & Drain</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Special Functions</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Front-loading drum, electronic control panel, detergent drawer, filter, drain pump, and adjustable feet.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Capacity</td><td>6kg dry laundry load</td></tr>
<tr><td>Energy Rating</td><td>A+++ for high efficiency</td></tr>
<tr><td>Spin Speed</td><td>Up to 1400 rpm (adjustable)</td></tr>
<tr><td>Programs</td><td>Cotton, Synthetic, Delicate, Quick Wash, etc.</td></tr>
<tr><td>Delay Start</td><td>Timer up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Display</td><td>LED indicators and time remaining</td></tr>
<tr><td>Door Lock</td><td>Automatic during operation</td></tr>
<tr><td>Water Inlet</td><td>Hot & cold water connections</td></tr>
<tr><td>Drain Hose</td><td>Adjustable height for proper drainage</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and remove transit bolts. Place on level floor.</p>
<ol>
<li>Remove transit bolts: Use spanner to remove 4 bolts at rear; keep for future moves.</li>
<li>Level the machine: Adjust front feet to ensure machine is stable; use spirit level.</li>
<li>Connect water supply: Attach hoses to hot/cold taps; ensure washers are fitted.</li>
<li>Connect drain hose: Place in standpipe or sink; secure to avoid slipping.</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in areas with freezing temperatures. Ensure water connections are tight to prevent leaks.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first wash, run a maintenance cycle.</p>
<ol>
<li>Check installation: Ensure all bolts removed, hoses connected, machine level.</li>
<li>Power on: Plug in and press POWER button.</li>
<li>Run empty wash: Select Cotton program at 90°C without laundry to clean drum.</li>
<li>Set preferences: Adjust default spin speed, temperature if needed via PROGRAM knob.</li>
<li>Load laundry: Do not exceed 6kg; distribute evenly.</li>
</ol>
<p><strong>CAUTION!</strong> Never use machine without removing transit bolts—it will cause severe vibration and damage.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko WML 6100 (example).</li>
<li><strong>Capacity:</strong> 6kg.</li>
<li><strong>Dimensions (HxWxD):</strong> 85cm x 60cm x 55cm.</li>
<li><strong>Voltage/Frequency:</strong> 220-240V, 50Hz.</li>
<li><strong>Power Consumption:</strong> 0.95 kWh per cycle (Cotton 60°C).</li>
<li><strong>Water Pressure:</strong> 0.5-10 bar.</li>
<li><strong>Programs:</strong> 15 including Eco, Wool, Hand Wash, Spin Only.</li>
<li><strong>Noise Level:</strong> 65 dB (washing), 75 dB (spinning).</li>
<li><strong>Weight:</strong> 65kg.</li>
<li><strong>Warranty:</strong> 2 years parts and labor.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: POWER button, PROGRAM knob, START/PAUSE, OPTIONS buttons (Temp, Spin, Delay), CHILD LOCK.</p>
<p><strong>Program Knob:</strong> Turn to select—Cotton, Synthetic, Delicates, Quick (30°C), Wool, Silk, Sportswear, Baby Care, Anti-Allergy, Drum Clean.</p>
<p>Options: Adjust temperature (cold to 90°C), spin speed (0-1400 rpm), delay start (1-24h). Display shows time remaining, cycle stage, and selected options. Child Lock: Press and hold CHILD LOCK for 3 seconds to activate/deactivate.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water & Drain</h2>
<p>Water Inlet: Two hoses (blue for cold, red for hot). Drain: Hose diameter 1.5 inches.</p>
<ol>
<li>Turn off water taps before connecting hoses.</li>
<li>Connect inlet hoses to taps and machine; hand-tighten, then use pliers for quarter turn.</li>
<li>Place drain hose in standpipe (max height 100cm) or over sink edge; secure with hook.</li>
<li>Check for leaks by turning on taps briefly before first wash.</li>
</ol>
<p><strong>Tip:</strong> Use drain hose extension if needed; avoid kinks or sharp bends.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Select program based on fabric type and soil level.</p>
<ol>
<li>Load laundry: Open door, place items loosely; do not overload.</li>
<li>Add detergent: Pour into drawer compartment II (main wash).</li>
<li>Select program: Turn knob to desired program (e.g., Cotton for towels).</li>
<li>Adjust options: Press TEMP or SPIN to modify.</li>
<li>Start: Press START/PAUSE; door locks and cycle begins.</li>
<li>Pause/Add: Press START/PAUSE to stop; wait for door unlock to add forgotten items.</li>
<li>End: Machine beeps; remove laundry promptly to avoid wrinkles.</li>
</ol>
<p><strong>WARNING!</strong> Do not open door during high-temperature washes; steam may cause burns.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Special Functions</h2>
<p>Delay Start: Set delay (1-24h) to finish at desired time. Extra Rinse: Adds rinse cycle for sensitive skin. Pre-Wash: For heavily soiled loads; add detergent to compartment I. Speed Wash: Reduces time for lightly soiled loads. Drum Clean: Run monthly without laundry at 90°C to prevent odors.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug before maintenance. Wipe exterior with damp cloth. Clean detergent drawer monthly; remove and rinse under tap. Clean filter every 2 months: Turn off water, place towel below, open filter cover, drain residual water, remove debris. Clean door seal: Wipe with soft cloth to remove lint and residue.</p>
<p><strong>CAUTION!</strong> Never use abrasive cleaners or solvents on surfaces.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked; complies with EU directives for safety and electromagnetic compatibility. Energy label according to EU Regulation 2019/2014. Manufactured by Beko PLC. For support, visit www.beko.com or contact customer service at 0333 207 9710 (UK).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Door not closed/power</td><td>Close door firmly; check plug and power outlet; press START/PAUSE.</td></tr>
<tr><td>No water intake</td><td>Taps closed/hose kinked</td><td>Open taps; check hose for kinks; clean inlet filter.</td></tr>
<tr><td>Excessive vibration</td><td>Transit bolts not removed/uneven load</td><td>Remove transit bolts; redistribute laundry; ensure machine is level.</td></tr>
<tr><td>Water not draining</td><td>Drain hose blocked/filter clogged</td><td>Check hose for blockages; clean pump filter.</td></tr>
<tr><td>Error code E01</td><td>Water supply issue</td><td>Check water pressure; ensure taps are fully open.</td></tr>
<tr><td>Detergent not dissolving</td><td>Drawer clogged</td><td>Remove and clean detergent drawer.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart.</p>
<p><strong>Service:</strong> 0333 207 9710; www.beko.com</p>
<div style="text-align: center;">
Beko 6kg Washing Machine Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
