<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko 7kg Washing Machine Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko 7kg Washing Machine Manual</h1>
<p>The Beko 7kg Washing Machine is a front-loading appliance designed for efficient home laundry, featuring a 7kg capacity, multiple wash programs, energy-saving technology, child lock, delay start, and spin speed adjustments. Below are key sections for safety, features, installation, setup, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water Supply</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Front-loading drum, Control Panel, Detergent Dispenser, Water Inlet Valves, Drain Hose, Power Cord.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Capacity</td><td>7kg (dry laundry weight)</td></tr>
<tr><td>Wash Programs</td><td>Multiple programs for cotton, synthetics, delicate, quick wash, etc.</td></tr>
<tr><td>Spin Speed</td><td>Adjustable up to 1200 rpm</td></tr>
<tr><td>Energy Rating</td><td>A+++ for energy efficiency</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Delay Start</td><td>Program start delay up to 24 hours</td></tr>
<tr><td>Detergent Dispenser</td><td>Compartments for pre-wash, main wash, fabric softener</td></tr>
<tr><td>Display</td><td>LED display showing time, program, and settings</td></tr>
<tr><td>Door Lock</td><td>Automatic door lock during operation</td></tr>
<tr><td>Rinse Hold</td><td>Option to pause before final spin</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on level, solid floor.</p>
<ol>
<li>Remove transit bolts: Use spanner to remove bolts at rear; keep for future moves.</li>
<li>Connect water supply: Attach inlet hoses to cold water tap (and hot if applicable).</li>
<li>Connect drain hose: Place in standpipe or sink; secure to avoid slipping.</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in wet areas. Ensure transit bolts are removed to prevent damage.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Power on machine; run initial empty wash.</p>
<ol>
<li>Check connections: Ensure water and drain hoses are secure.</li>
<li>Select program: Turn dial to "Cotton" and press Start without laundry.</li>
<li>Add detergent: Pour 100ml of detergent into main wash compartment.</li>
<li>Run cycle: Let complete to clean drum and remove residues.</li>
<li>Set preferences: Adjust default spin speed, temperature if needed via settings.</li>
</ol>
<p><strong>CAUTION!</strong> Do not load laundry during first wash. Keep children away during installation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Capacity:</strong> 7kg.</li>
<li><strong>Dimensions (HxWxD):</strong> 85cm x 60cm x 55cm.</li>
<li><strong>Power Supply:</strong> 220-240V, 50Hz.</li>
<li><strong>Water Pressure:</strong> 0.5-10 bar.</li>
<li><strong>Max Spin Speed:</strong> 1200 rpm.</li>
<li><strong>Programs:</strong> Cotton, Synthetics, Delicates, Wool, Quick Wash, Eco, Spin Only, Rinse Only.</li>
<li><strong>Noise Level:</strong> Wash: 55 dB; Spin: 75 dB.</li>
<li><strong>Weight:</strong> 65kg.</li>
<li><strong>Warranty:</strong> 2 years parts and labor.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: Program Dial, Start/Pause, Temperature, Spin Speed, Delay Start, Option Buttons.</p>
<p><strong>Program Selection:</strong> Turn dial to desired program (Cotton, Synthetics, etc.). Temperature: Adjust with Temp button (30°C to 90°C). Spin Speed: Adjust with Spin button (0 to 1200 rpm). Delay Start: Press Delay to set start time (1-24 hours). Child Lock: Press and hold Start + Spin for 3 seconds to enable/disable.</p>
<p>Display: Shows remaining time, selected program, temperature, spin speed, and delay time.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water Supply</h2>
<p>Cold water connection standard; hot water optional.</p>
<ol>
<li>Turn off water taps before connecting hoses.</li>
<li>Attach inlet hoses to machine valves (blue for cold, red for hot).</li>
<li>Connect other ends to water taps; ensure washers are fitted.</li>
<li>Open taps slowly; check for leaks.</li>
<li>Place drain hose in standpipe (max height 100cm) or over sink edge.</li>
</ol>
<p><strong>Tip:</strong> Use only provided hoses; do not overtighten connections.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Select program based on fabric type and soil level.</p>
<ol>
<li>Load laundry: Open door, load evenly up to 7kg; close door firmly.</li>
<li>Add detergent: Pour into correct compartments (pre-wash, main, softener).</li>
<li>Select program: Turn dial (e.g., Cotton for normal loads).</li>
<li>Adjust settings: Set temperature, spin speed, delay if needed.</li>
<li>Start: Press Start/Pause; door locks automatically.</li>
<li>Pause/Stop: Press Start/Pause to pause; press again to resume. Hold to cancel.</li>
<li>End of cycle: Signal sounds; door unlocks after a few minutes.</li>
</ol>
<p><strong>WARNING!</strong> Do not open door during wash; wait for unlock signal. Do not exceed max load.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Child Lock: Locks control panel to prevent changes. Door Lock: Auto-locks during operation; unlocks at end. Overflow Protection: Stops water if level too high. Imbalance Control: Reduces spin speed if load uneven.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug before cleaning. Wipe exterior with damp cloth; clean detergent drawer monthly; run drum clean program every 30 cycles.</p>
<p><strong>CAUTION!</strong> Do not use abrasive cleaners; keep ventilation openings clear.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked; complies with EU directives for safety and EMC. Energy label: A+++. For support, visit www.beko.com or contact 0333 207 9710 (UK).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Power/door</td><td>Check plug; ensure door closed properly; press Start firmly.</td></tr>
<tr><td>No water intake</td><td>Taps/hoses</td><td>Ensure taps open; check hose for kinks; clean inlet filter.</td></tr>
<tr><td>Water doesn't drain</td><td>Drain hose</td><td>Check for blockages; ensure hose not too high; clean pump filter.</td></tr>
<tr><td>Excessive vibration</td><td>Transit bolts/load</td><td>Ensure transit bolts removed; redistribute laundry evenly.</td></tr>
<tr><td>Error codes on display</td><td>Various faults</td><td>Refer to manual error code list; unplug for 5 minutes, restart.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes; plug back in.</p>
<p><strong>Service:</strong> 0333 207 9710; www.beko.com</p>
<div style="text-align: center;">
Beko 7kg Washing Machine Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
