<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko B300 Dishwasher Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko B300 Dishwasher Manual</h1>
<p>The Beko B300 is a freestanding dishwasher featuring a 12-place setting capacity, energy efficiency class A, 6 wash programs (including Intensive, Eco, and Quick Wash), half-load option, adjustable upper basket, salt and rinse aid indicators, child lock, delay start timer (up to 24 hours), and acoustic signal. Designed for standard kitchen installation with dimensions 60x60x85 cm (WxDxH). Below are key sections for safety, features, installation, setup, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Loading the Dishwasher</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Care & Maintenance</a>
<a href="#section10">9. Safety Information</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Control panel with digital display, Upper and lower baskets, Cutlery basket, Filter system, Salt container, Rinse aid dispenser, Water inlet and drain hoses.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>12-place setting capacity</td><td>Holds up to 12 standard place settings</td></tr>
<tr><td>6 wash programs</td><td>Includes Intensive, Eco, Quick, Normal, Glass, and Rinse</td></tr>
<tr><td>Half-load option</td><td>Reduces water and energy for smaller loads</td></tr>
<tr><td>Adjustable upper basket</td><td>Height adjustable for taller items</td></tr>
<tr><td>Salt and rinse aid indicators</td><td>LED alerts for refilling</td></tr>
<tr><td>Child lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Delay start timer</td><td>Program start delay up to 24 hours</td></tr>
<tr><td>Acoustic signal</td><td>Audible end-of-cycle signal</td></tr>
<tr><td>Energy class A</td><td>High energy efficiency rating</td></tr>
<tr><td>Water consumption</td><td>Approx. 10-12 liters per cycle (Eco program)</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure installation area is level and near water/drain connections.</p>
<ol>
<li>Position dishwasher: Place in desired location, ensuring 5cm clearance at rear and sides.</li>
<li>Connect water supply: Attach inlet hose to cold water tap (max pressure 1 MPa).</li>
<li>Connect drain hose: Route to sink drain or standpipe (min height 40cm, max 100cm).</li>
<li>Level the appliance: Adjust feet to ensure stability.</li>
<li>Electrical connection: Plug into grounded 220-240V, 50Hz outlet.</li>
</ol>
<p><strong>WARNING!</strong> Only use specified hoses; do not kink or bend sharply. Ensure power cord is not trapped.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, remove transport locks and prepare the dishwasher.</p>
<ol>
<li>Remove packaging: Take off all tape and protective films.</li>
<li>Set water hardness: Adjust salt dispenser setting based on local water hardness.</li>
<li>Fill salt container: Add 1kg of special dishwasher salt (first use requires 1 liter of water in container).</li>
<li>Fill rinse aid: Pour into dispenser until MAX indicator.</li>
<li>Run initial cycle: Select Intensive program without dishes to clean interior.</li>
</ol>
<p><strong>CAUTION!</strong> Only use dishwasher salt and rinse aid; table salt will damage the appliance.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko B300</li>
<li><strong>Type:</strong> Freestanding dishwasher</li>
<li><strong>Capacity:</strong> 12 place settings</li>
<li><strong>Dimensions (WxDxH):</strong> 60 x 60 x 85 cm</li>
<li><strong>Voltage/Frequency:</strong> 220-240V, 50Hz</li>
<li><strong>Power Consumption:</strong> 0.78 kWh (Eco program)</li>
<li><strong>Water Consumption:</strong> 10-12 liters (Eco program)</li>
<li><strong>Noise Level:</strong> 49 dB(A)</li>
<li><strong>Wash Programs:</strong> 6 programs + 4 temperature options</li>
<li><strong>Special Features:</strong> Half-load, delay start, child lock, adjustable basket</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: ON/OFF button, Program selector, Delay start, Half-load, Child lock, Start/Pause.</p>
<p><strong>Program Selection:</strong> Turn knob to desired program. LED display shows remaining time.</p>
<p>Settings: Delay start (1-24 hours), Half-load (activates for upper basket only), Child lock (press 3 seconds to activate/deactivate). Salt refill indicator lights when salt container is empty. Rinse aid indicator lights when dispenser needs refilling.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Loading the Dishwasher</h2>
<p>Proper loading ensures optimal cleaning and prevents damage.</p>
<ol>
<li>Scrape off large food residues (no pre-rinsing required).</li>
<li>Load lower basket: Pots, pans, plates, bowls (facing center).</li>
<li>Load upper basket: Glasses, cups, saucers, small plates.</li>
<li>Cutlery basket: Place knives, forks, spoons with handles down.</li>
<li>Adjust upper basket: Lift to higher position for tall items.</li>
<li>Ensure spray arms rotate freely and items don't block them.</li>
</ol>
<p><strong>Tip:</strong> Do not overload; leave space between items for water circulation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Select program based on soil level and dish type.</p>
<table>
<tr><th>Program</th><th>Temperature</th><th>Use For</th><th>Duration</th></tr>
<tr><td>Intensive</td><td>70°C</td><td>Heavily soiled pots, pans</td><td>120 min</td></tr>
<tr><td>Eco</td><td>50°C</td><td>Normally soiled dishes</td><td>180 min</td></tr>
<tr><td>Quick</td><td>45°C</td><td>Lightly soiled, quick wash</td><td>30 min</td></tr>
<tr><td>Normal</td><td>65°C</td><td>Daily use, mixed load</td><td>105 min</td></tr>
<tr><td>Glass</td><td>40°C</td><td>Glassware, delicate items</td><td>90 min</td></tr>
<tr><td>Rinse</td><td>Cold</td><td>Rinse only, no detergent</td><td>15 min</td></tr>
</table>
<p><strong>Operation:</strong> Add detergent to dispenser, select program, press Start. Door locks automatically during cycle.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Care & Maintenance</h2>
<p>Regular maintenance ensures optimal performance and longevity.</p>
<ol>
<li>Clean filter weekly: Remove lower basket, twist and lift out filter, rinse under water.</li>
<li>Clean spray arms monthly: Check for blockages, rinse under water.</li>
<li>Wipe door seals: Clean with damp cloth to prevent mold.</li>
<li>Descale monthly: Run empty cycle with dishwasher cleaner or vinegar.</li>
<li>Check salt and rinse aid: Refill as indicated by LED lights.</li>
</ol>
<p><strong>CAUTION!</strong> Unplug before maintenance. Never use abrasive cleaners or sharp objects.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Safety Information</h2>
<p>Read all instructions before installation and use.</p>
<ul>
<li>Connect to grounded outlet only.</li>
<li>Do not open door during hot wash cycles (risk of scalding).</li>
<li>Keep children away from open dishwasher and detergent.</li>
<li>Use only dishwasher detergent (hand soap damages appliance).</li>
<li>Do not wash items soiled with flammable substances.</li>
<li>Disconnect power before servicing.</li>
</ul>
<p><strong>WARNING!</strong> Detergents are corrosive; keep away from children and skin.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked: Complies with European Directives. Energy label: Class A according to EU regulation 1059/2010. Waste disposal: Dispose according to local regulations; contact municipal waste facility. Manufacturer: Beko PLC, Turkey. For support, visit www.beko.com or contact local service center.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Dishwasher won't start</td><td>Power supply/door</td><td>Check plug, fuse, circuit breaker; ensure door closed properly.</td></tr>
<tr><td>Poor cleaning results</td><td>Loading/detergent</td><td>Check loading; use correct detergent amount; clean filter.</td></tr>
<tr><td>Water not draining</td><td>Drain hose/filter</td><td>Check hose for kinks; clean filter; ensure drain height correct.</td></tr>
<tr><td>Leaking water</td><td>Door seal/hose</td><td>Check door seal for debris; tighten hose connections.</td></tr>
<tr><td>Noise during operation</td><td>Spray arm/items</td><td>Ensure spray arms rotate freely; check for loose items touching arms.</td></tr>
<tr><td>Salt indicator stays on</td><td>Salt container empty</td><td>Refill salt container; check water hardness setting.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart.</p>
<p><strong>Service:</strong> Contact authorized Beko service center; do not attempt repairs yourself.</p>
<div style="text-align: center;">
Beko B300 Dishwasher Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
