<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko B300 Washing Machine Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko B300 Washing Machine Manual</h1>
<p>The Beko B300 is a front-loading washing machine with a 7kg capacity, featuring multiple wash programs, energy efficiency class A+++, spin speed up to 1400 RPM, delay timer, child lock, and anti-allergy cycle. It includes automatic load detection, imbalance control, and aquastop leak protection. Below are key sections for safety, features, installation, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water & Drain</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Special Functions</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Front-loading drum, electronic control panel, detergent drawer, filter, drain pump, and adjustable feet.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Capacity</td><td>7kg laundry load</td></tr>
<tr><td>Energy Class</td><td>A+++ (most efficient)</td></tr>
<tr><td>Spin Speed</td><td>Up to 1400 RPM</td></tr>
<tr><td>Programs</td><td>Cotton, Synthetic, Delicate, Quick Wash, Anti-Allergy, etc.</td></tr>
<tr><td>Delay Timer</td><td>Up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Aquastop</td><td>Automatic water shut-off in case of leak</td></tr>
<tr><td>Imbalance Control</td><td>Reduces vibration during spin</td></tr>
<tr><td>Automatic Load Detection</td><td>Adjusts water and energy usage</td></tr>
<tr><td>Display</td><td>LED with time remaining and cycle indicators</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on a level, solid floor.</p>
<ol>
<li>Remove transit bolts: Use spanner to remove bolts at rear; keep for future moves.</li>
<li>Adjust feet: Level the machine using a spirit level; tighten lock nuts.</li>
<li>Connect water supply: Attach inlet hose to cold water tap (3/4” thread).</li>
<li>Connect drain hose: Place in standpipe or sink (max height 1m).</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in areas below 0°C. Ensure transit bolts are removed before use.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first wash, run a maintenance cycle.</p>
<ol>
<li>Power on machine: Plug in and press POWER button.</li>
<li>Run empty wash: Select Cotton 90°C program without laundry.</li>
<li>Set language: Press and hold START/PAUSE and SPIN buttons for 3 seconds to select language.</li>
<li>Load laundry: Sort by fabric type and color.</li>
<li>Add detergent: Use drawer compartments I (pre-wash), II (main wash), * (softener).</li>
</ol>
<p><strong>CAUTION!</strong> Overloading reduces wash efficiency. Follow load guidelines.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko B300</li>
<li><strong>Capacity:</strong> 7kg (dry weight)</li>
<li><strong>Dimensions (HxWxD):</strong> 85cm x 60cm x 60cm</li>
<li><strong>Voltage/Frequency:</strong> 230V~50Hz</li>
<li><strong>Power Consumption:</strong> 2100W (heating)</li>
<li><strong>Water Pressure:</strong> 0.5-10 bar</li>
<li><strong>Programs:</strong> 15 including Eco 40-60, Wool, Hand Wash</li>
<li><strong>Noise Level:</strong> 53 dB (wash), 75 dB (spin)</li>
<li><strong>Weight:</strong> 68kg</li>
<li><strong>Certifications:</strong> CE, RoHS, WEEE</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: POWER, PROGRAM SELECTOR knob, START/PAUSE, OPTION buttons (Delay, Extra Rinse, Pre-wash), SPIN SPEED button, TEMPERATURE button.</p>
<p><strong>Display:</strong> Shows program time, spin speed, temperature, delay time, and error codes.</p>
<p>Program Selection: Turn knob to desired program (Cotton, Synthetic, Delicate, Quick 30', etc.). Options: Press to activate Extra Rinse, Pre-wash, or Delay (1-24h). Temperature: Select from Cold, 30°C, 40°C, 60°C, 90°C. Spin Speed: Choose from No Spin, 400, 600, 800, 1000, 1200, 1400 RPM. Child Lock: Press and hold DELAY and EXTRA RINSE for 3 seconds.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water & Drain</h2>
<p>Water Inlet: Cold fill only (hose supplied). Drain: Hose diameter 19mm, max length 1.5m.</p>
<ol>
<li>Ensure water tap is off before connecting hose.</li>
<li>Secure hose with clamp; do not overtighten.</li>
<li>Drain hose must not be kinked or submerged.</li>
<li>Check for leaks after first connection.</li>
</ol>
<p><strong>Tip:</strong> Use a drain hose extension if needed; ensure proper slope for drainage.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Select program based on fabric type and soil level.</p>
<ol>
<li>Load laundry: Do not exceed 7kg; distribute evenly.</li>
<li>Add detergent: Use correct compartment; follow dosage instructions.</li>
<li>Select program: Turn knob (e.g., Cotton for towels/bedding).</li>
<li>Set options: Temperature, spin speed, extra functions.</li>
<li>Start: Press START/PAUSE; door locks automatically.</li>
<li>Pause/change: Press START/PAUSE to stop; wait 2 minutes to unlock door.</li>
<li>End of cycle: Signal sounds; door unlocks after a short delay.</li>
</ol>
<p><strong>WARNING!</strong> Do not open door during high-temperature washes. Wait for cool-down.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Special Functions</h2>
<p>Delay Timer: Set 1-24 hours delay start. Extra Rinse: Adds rinse cycle for sensitive skin. Pre-wash: For heavily soiled items. Anti-Allergy: Heats water to 60°C to remove allergens. Quick 30': Fast wash for lightly soiled loads. Silent Mode: Reduces spin speed for quiet operation (selectable in settings).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Monthly maintenance ensures longevity.</p>
<ol>
<li>Clean detergent drawer: Remove and rinse under warm water.</li>
<li>Clean filter: Turn off power; open filter cover at front; remove debris.</li>
<li>Clean drum: Run Cotton 90°C program empty with washing machine cleaner.</li>
<li>Wipe door seal: Remove lint and residue; leave door ajar after use.</li>
</ol>
<p><strong>CAUTION!</strong> Unplug before cleaning filter. Do not use abrasive cleaners on surfaces.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>EU Ecodesign Directive compliant. Conforms to EN 60456 performance standards. Waste electrical products must not be disposed of with household waste. Please recycle according to local regulations. For support, visit www.beko.com or contact customer service at 0333 207 9710 (UK).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Power/door</td><td>Check plug; ensure door is closed properly; press START/PAUSE.</td></tr>
<tr><td>No water intake</td><td>Tap/hose/filter</td><td>Open water tap; check hose for kinks; clean inlet filter.</td></tr>
<tr><td>Excessive vibration</td><td>Transit bolts/load</td><td>Ensure transit bolts removed; redistribute laundry; level feet.</td></tr>
<tr><td>Water not draining</td><td>Drain hose/filter</td><td>Check hose for blockages; clean pump filter.</td></tr>
<tr><td>Error code E01</td><td>Water inlet fault</td><td>Check water supply; restart machine.</td></tr>
<tr><td>Error code E02</td><td>Drain fault</td><td>Clear drain hose; check pump filter.</td></tr>
<tr><td>Detergent not dissolving</td><td>Drawer compartment</td><td>Use correct compartment (II for main wash); use powder/liquid as directed.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes to reset electronics.</p>
<p><strong>Service:</strong> 0333 207 9710; www.beko.com</p>
<div style="text-align: center;">
Beko B300 Washing Machine Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
