<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko BPRO500 Washing Machine Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko BPRO500 Washing Machine Manual</h1>
<p>The Beko BPRO500 is a front-loading washing machine with a 5kg capacity, featuring multiple wash programs, energy efficiency, child lock, delay start, and a digital display. It is designed for household use with standard 220-240V, 50Hz power supply. Below are key sections for safety, features, installation, setup, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water & Drain</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Special Functions</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Front-loading drum, Digital Control Panel, Detergent Drawer, Water Inlet Valves, Drain Pump, Adjustable Feet, Power Cord.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Capacity</td><td>5kg (dry laundry weight)</td></tr>
<tr><td>Spin Speed</td><td>Up to 1200 RPM</td></tr>
<tr><td>Energy Rating</td><td>A+++ (Most Efficient)</td></tr>
<tr><td>Display</td><td>Digital LED with time remaining</td></tr>
<tr><td>Programs</td><td>Cotton, Synthetic, Delicate, Quick Wash, Wool, etc.</td></tr>
<tr><td>Special Functions</td><td>Delay Start, Child Lock, Extra Rinse, Pre-wash</td></tr>
<tr><td>Door</td><td>Transparent glass with safety lock</td></tr>
<tr><td>Detergent Drawer</td><td>Compartments for pre-wash, main wash, softener</td></tr>
<tr><td>Water Inlets</td><td>Hot & Cold water connections</td></tr>
<tr><td>Dimensions (HxWxD)</td><td>85cm x 60cm x 54cm</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on a solid, level floor.</p>
<ol>
<li>Remove transit bolts: Use spanner to remove 4 bolts at rear; keep for future moves.</li>
<li>Adjust feet: Turn to level machine; use spirit level to check.</li>
<li>Connect water supply: Attach inlet hoses to hot/cold taps (if available) and machine inlets.</li>
<li>Connect drain hose: Place in standpipe or sink (max height 100cm).</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in areas prone to freezing or direct sunlight. Ensure water connections are tight to prevent leaks.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first wash, run a maintenance cycle.</p>
<ol>
<li>Power on: Plug in and press Power button.</li>
<li>Run empty wash: Select "Cotton 90°C" program without laundry and start to clean drum.</li>
<li>Set preferences: Use Settings button to adjust buzzer volume, default spin speed, etc.</li>
<li>Load detergent: Fill drawer compartments as per detergent instructions.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure transit bolts are removed before first use to prevent damage.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko BPRO500</li>
<li><strong>Capacity:</strong> 5kg</li>
<li><strong>Max Spin Speed:</strong> 1200 RPM</li>
<li><strong>Water Pressure:</strong> 0.5 - 10 bar</li>
<li><strong>Programs:</strong> 15 programs including Cotton, Eco, Quick, Delicate, Wool, Spin, Rinse</li>
<li><strong>Power Supply:</strong> 220-240V, 50Hz</li>
<li><strong>Energy Consumption:</strong> 0.75 kWh per cycle (Cotton 60°C)</li>
<li><strong>Water Consumption:</strong> Approx. 45 liters per cycle (Cotton 60°C)</li>
<li><strong>Noise Level:</strong> Wash: 56 dB, Spin: 76 dB</li>
<li><strong>Weight:</strong> 62kg</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: POWER button, Program Dial, Start/Pause, Delay Start, Child Lock, Extra Rinse, Pre-wash, Spin Speed, Temperature.</p>
<p><strong>Program Dial:</strong> Turn to select desired wash program. LED indicators show selected options.</p>
<p>Settings Menu: Press and hold Settings button for 3 seconds to access: Buzzer On/Off, Default Spin Speed, Temperature Adjustment, End of Cycle Signal. Child Lock: Press and hold Child Lock button for 3 seconds to activate/deactivate (prevents accidental changes). Delay Start: Press to set start time (1-24 hours).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water & Drain</h2>
<p>Water Inlet: Connect hoses to hot/cold taps (red/blue markings). Drain: Secure hose to standpipe or sink edge.</p>
<ol>
<li>Ensure taps are off before connecting hoses.</li>
<li>Use only supplied hoses; do not overtighten.</li>
<li>Drain hose must not be kinked or submerged.</li>
<li>After connections, open taps slowly and check for leaks.</li>
</ol>
<p><strong>Tip:</strong> Install a drip tray or leak detector for added safety.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Select program based on fabric type and soil level.</p>
<ol>
<li>Load laundry: Open door, load evenly, do not overload.</li>
<li>Add detergent: Pour into correct drawer compartment (II for main wash).</li>
<li>Select program: Turn dial (e.g., Cotton, Synthetic, Quick 30').</li>
<li>Adjust options: Press Spin Speed, Temperature, Extra Rinse as needed.</li>
<li>Start: Press Start/Pause; display shows time remaining.</li>
<li>Pause/Stop: Press Start/Pause to pause; turn dial to "Stop" to cancel.</li>
<li>After cycle: Remove laundry promptly; leave door ajar to dry drum.</li>
</ol>
<p><strong>WARNING!</strong> Do not wash items contaminated with petrol, solvents, or chemicals. Remove coins, keys from pockets.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Special Functions</h2>
<p>Delay Start: Set start time (1-24h) for convenient washing. Child Lock: Locks control panel. Extra Rinse: Adds rinse cycle for sensitive skin. Pre-wash: For heavily soiled loads. Rapid Wash: Reduces cycle time for lightly soiled loads.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Monthly maintenance recommended.</p>
<ol>
<li>Clean detergent drawer: Pull out, rinse under tap, dry and reinsert.</li>
<li>Clean door seal: Wipe with damp cloth to remove lint/residue.</li>
<li>Clean filter: Locate at front bottom right; turn counterclockwise to open; remove debris.</li>
<li>Run maintenance cycle: Use "Drum Clean" program or Cotton 90°C empty wash monthly.</li>
</ol>
<p><strong>CAUTION!</strong> Unplug before cleaning. Do not use abrasive cleaners or high-pressure water.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE Mark: Complies with European safety and EMC directives. Waste Electrical and Electronic Equipment (WEEE): Do not dispose with household waste; recycle appropriately. Manufacturer: Beko PLC. For support, visit www.beko.com or contact local service center.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Power, door, child lock</td><td>Check plug/power; ensure door closed; deactivate child lock.</td></tr>
<tr><td>No water intake</td><td>Taps, hoses, filter</td><td>Ensure taps on; check hose kinks; clean inlet filter.</td></tr>
<tr><td>Water doesn't drain</td><td>Drain hose, pump filter</td><td>Check hose for kinks/blockage; clean pump filter.</td></tr>
<tr><td>Excessive vibration/noise</td><td>Transit bolts, leveling, load</td><td>Ensure transit bolts removed; re-level feet; redistribute load.</td></tr>
<tr><td>Error codes (e.g., E01, E10)</td><td>See manual chart</td><td>Refer to error code list in manual; reset by unplugging for 5 mins.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart.</p>
<p><strong>Service:</strong> Contact authorized Beko service center. Do not attempt repairs yourself.</p>
<div style="text-align: center;">
Beko BPRO500 Washing Machine Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
