<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Built In Oven Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Built In Oven Manual</h1>
<p>The Beko Built In Oven is a modern, energy-efficient appliance designed for seamless kitchen integration. It features multiple cooking functions (fan oven, conventional, grill, defrost), digital controls with timer, child safety lock, interior oven light, removable door and shelves for easy cleaning, and energy-saving eco mode. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Cooking Functions</a>
<a href="#section8">7. Cleaning & Maintenance</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Regulatory Information</a>
<a href="#section11">10. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Digital control panel, oven cavity with enamel coating, fan heating element, grill element, removable door, interior light, telescopic runners (on select models).</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Control Panel</td><td>Digital display with touch buttons for temperature, timer, and functions</td></tr>
<tr><td>Cooking Functions</td><td>Fan oven, conventional, grill, defrost, pizza setting</td></tr>
<tr><td>Timer</td><td>60-minute mechanical or digital timer with end-of-cooking signal</td></tr>
<tr><td>Child Lock</td><td>Safety lock to prevent unintended operation</td></tr>
<tr><td>Interior Light</td><td>LED light for visibility during cooking</td></tr>
<tr><td>Removable Door</td><td>Easy removal for thorough cleaning</td></tr>
<tr><td>Removable Shelves</td><td>Chrome-plated wire shelves, adjustable on multiple levels</td></tr>
<tr><td>Energy Rating</td><td>A+ or higher for energy efficiency</td></tr>
<tr><td>Eco Function</td><td>Reduces energy consumption during longer cooking</td></tr>
<tr><td>Cool-Touch Door</td><td>Stays cool to the touch during operation for safety</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure proper kitchen cabinet cutout dimensions.</p>
<ol>
<li>Prepare cabinet: Measure and cut opening according to dimensions in manual.</li>
<li>Electrical connection: Must be performed by qualified electrician. Connect to appropriate power supply (220-240V, 50Hz).</li>
<li>Secure oven: Slide oven into cabinet, ensuring it is level and stable.</li>
<li>Attach door: If removed, reattach door according to instructions.</li>
</ol>
<p><strong>WARNING!</strong> Oven is heavy; use two people for handling. Disconnect power before installation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>After installation, perform initial setup.</p>
<ol>
<li>Remove protective film: Peel off any protective coatings from surfaces.</li>
<li>Initial heating: Run oven empty at max temperature for 60 minutes to burn off manufacturing residues.</li>
<li>Set clock: Use control panel to set current time.</li>
<li>Test functions: Briefly test each cooking function to ensure proper operation.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure adequate ventilation. Keep flammable materials away during first heating.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Type:</strong> Built-in single oven.</li>
<li><strong>Energy Class:</strong> A+ (or as per model).</li>
<li><strong>Capacity:</strong> 60-70 liters (varies by model).</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50Hz.</li>
<li><strong>Power Consumption:</strong> 2000-3000W (max).</li>
<li><strong>Cooking Functions:</strong> Fan, Conventional, Grill, Defrost, Pizza.</li>
<li><strong>Temperature Range:</strong> 50°C - 250°C.</li>
<li><strong>Timer:</strong> Up to 60 minutes with audible signal.</li>
<li><strong>Dimensions (HxWxD):</strong> Approximately 595 x 595 x 550 mm (varies).</li>
<li><strong>Weight:</strong> Approximately 30 kg.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Access functions via control panel. Main buttons: FUNCTION SELECTOR, TEMPERATURE +/- , TIMER, CHILD LOCK.</p>
<p><strong>Display Icons:</strong> Fan symbol, grill symbol, clock, lock symbol, temperature reading.</p>
<p>Function Selection: Turn knob or press button to select cooking mode. Temperature Setting: Use +/- buttons or knob to set desired temperature (50-250°C). Timer Setting: Set cooking duration; oven will beep and turn off automatically. Child Lock: Press and hold LOCK button for 3 seconds to enable/disable. Interior Light: Turns on when door opens or manually via button (if available).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Cooking Functions</h2>
<p>Select function based on food type.</p>
<ol>
<li>Fan Oven: Circulates hot air for even cooking. Ideal for baking and roasting.</li>
<li>Conventional: Top and bottom heating. Good for traditional baking.</li>
<li>Grill: Top heating element for browning and grilling.</li>
<li>Defrost: Gentle fan without heat to thaw frozen food.</li>
<li>Pizza Function: Combines fan and bottom heat for crispy pizza base.</li>
<li>Eco Mode: Uses lower temperature and fan for energy-efficient slow cooking.</li>
</ol>
<p><strong>Tip:</strong> Preheat oven for 10-15 minutes before cooking for best results.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Cleaning & Maintenance</h2>
<p>Always disconnect power and allow oven to cool completely before cleaning.</p>
<ol>
<li>Interior: Use mild detergent and soft cloth. Do not use abrasive cleaners.</li>
<li>Door: Remove by lifting and pulling. Clean glass with suitable cleaner.</li>
<li>Shelves and Trays: Remove and wash in warm soapy water.</li>
<li>Control Panel: Wipe with damp cloth; do not allow water to enter buttons.</li>
<li>Oven Cavity: Use oven cleaner sparingly if heavily soiled; follow product instructions.</li>
</ol>
<p><strong>CAUTION!</strong> Never use steam cleaners, sharp objects, or harsh chemicals on surfaces.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Child Lock: Prevents accidental changes to settings. Cool-Touch Door: Reduces risk of burns. Auto Shut-Off: Timer turns off heating elements after set time. Overheat Protection: Thermal cut-out activates if temperature exceeds safe limit.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Regulatory Information</h2>
<p>CE Marked: Complies with EU safety standards. WEEE Directive: Do not dispose with household waste; recycle appropriately. For support, visit www.beko.com or contact local service center. This appliance is intended for household use only.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Oven not heating</td><td>Power supply, function selection</td><td>Check power connection; ensure function and temperature are set correctly.</td></tr>
<tr><td>Display not working</td><td>Power, child lock</td><td>Check mains power; disable child lock if enabled.</td></tr>
<tr><td>Uneven cooking</td><td>Shelves position, preheat</td><td>Use middle shelf; ensure oven is preheated; use fan function for even heat.</td></tr>
<tr><td>Door not closing properly</td><td>Obstruction, alignment</td><td>Check for food debris; ensure door is properly seated and aligned.</td></tr>
<tr><td>Strange smell during first use</td><td>Manufacturing residues</td><td>Normal during first few uses; run empty at high temperature as per initial setup.</td></tr>
<tr><td>Timer not functioning</td><td>Settings, power interruption</td><td>Reset timer; check if clock is set; power cycle the oven.</td></tr>
</table>
<p><strong>Reset:</strong> Disconnect from power for 2 minutes, then reconnect to reset electronic controls.</p>
<p><strong>Service:</strong> Contact authorized Beko service center. Do not attempt repairs yourself.</p>
<div style="text-align: center;">
Beko Built In Oven Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
