<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Built In Oven User Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Built In Oven User Manual</h1>
<p>The Beko Built In Oven is a modern, energy-efficient oven designed for seamless integration into kitchen cabinetry. It features multiple cooking functions, precise temperature control, a timer, child lock, and easy-to-clean surfaces. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting to Power</a>
<a href="#section8">7. Cooking Functions</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Oven cavity, control panel, heating elements, fan, oven light, door with glass panel, and removable racks.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Control Panel</td><td>Digital display with touch controls for temperature, timer, and functions</td></tr>
<tr><td>Cooking Functions</td><td>Conventional, Fan, Grill, Defrost, and Pizza modes</td></tr>
<tr><td>Temperature Range</td><td>50°C to 250°C (adjustable in 5°C increments)</td></tr>
<tr><td>Timer</td><td>Up to 120 minutes with audible alert</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental operation</td></tr>
<tr><td>Oven Light</td><td>Illuminates interior for visibility</td></tr>
<tr><td>Removable Racks</td><td>Adjustable to multiple positions</td></tr>
<tr><td>Door Cooling System</td><td>Keeps exterior cool during operation</td></tr>
<tr><td>Energy Efficiency</td><td>Class A rating for reduced power consumption</td></tr>
<tr><td>Self-Cleaning Option</td><td>Pyrolytic cleaning function (select models)</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure proper cabinet cutout dimensions.</p>
<ol>
<li>Prepare cabinet: Cut opening according to dimensions in manual.</li>
<li>Secure oven: Insert oven into cabinet, ensuring it is level and flush.</li>
<li>Connect to power: Use appropriate electrical connection (see section 7).</li>
<li>Test operation: Power on and run initial setup.</li>
</ol>
<p><strong>WARNING!</strong> Installation must be performed by a qualified electrician. Ensure oven is disconnected from power during installation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Power on oven; follow initial configuration.</p>
<ol>
<li>Set clock: Press CLOCK button and adjust time using +/- buttons.</li>
<li>Select language: In SETTINGS menu, choose preferred language.</li>
<li>Calibrate temperature: Run calibration if needed (refer to manual).</li>
<li>Test functions: Run a short empty cycle to ensure all elements work.</li>
</ol>
<p><strong>CAUTION!</strong> Do not place any objects inside during first test. Ensure proper ventilation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Oven Type:</strong> Built-in electric oven.</li>
<li><strong>Capacity:</strong> 60 liters.</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50/60Hz.</li>
<li><strong>Power Consumption:</strong> 2.3 kW (max).</li>
<li><strong>External Dimensions:</strong> 595mm (W) x 595mm (H) x 550mm (D).</li>
<li><strong>Internal Dimensions:</strong> 450mm (W) x 350mm (H) x 450mm (D).</li>
<li><strong>Weight:</strong> 32 kg.</li>
<li><strong>Energy Rating:</strong> A.</li>
<li><strong>Warranty:</strong> 2 years standard.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Access functions via control panel. Buttons: POWER, FUNCTION SELECTOR, TEMPERATURE +/- , TIMER, CHILD LOCK.</p>
<p><strong>Display Icons:</strong> Clock, temperature, timer, function indicator, child lock symbol.</p>
<p>Cooking Functions: Conventional (top and bottom heat), Fan (circulated heat), Grill (top element), Defrost (fan without heat), Pizza (fan + bottom heat). Settings: Clock, temperature calibration, buzzer volume, language, reset to factory defaults.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting to Power</h2>
<p>Requires dedicated electrical circuit. Connection via terminal block at rear.</p>
<ol>
<li>Turn off main power at circuit breaker.</li>
<li>Connect live (brown), neutral (blue), and earth (green/yellow) wires to terminal block.</li>
<li>Secure connections and replace cover.</li>
<li>Restore power and test.</li>
</ol>
<p><strong>Tip:</strong> Use a 16A fuse or circuit breaker for this appliance.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Cooking Functions</h2>
<p>Supports various cooking modes for different foods.</p>
<ol>
<li>Select function: Press FUNCTION button and choose desired mode.</li>
<li>Set temperature: Use +/- buttons to adjust (50°C to 250°C).</li>
<li>Set timer: Press TIMER, set duration (up to 120 min).</li>
<li>Start cooking: Press START/PAUSE to begin.</li>
<li>Pause/stop: Press START/PAUSE to pause; press STOP to cancel.</li>
<li>Preheat: Oven beeps when set temperature is reached.</li>
<li>Use racks: Adjust to upper, middle, or lower positions as needed.</li>
</ol>
<p><strong>WARNING!</strong> Always use oven gloves when handling hot racks or trays. Do not place flammable materials inside.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Child Lock: Press and hold LOCK button for 3 seconds to enable/disable. Overheat Protection: Automatic shut-off if temperature exceeds safe limit. Door Safety Switch: Turns off heating when door is opened. Cooling Fan: Runs after cooking to cool components.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug or turn off power before cleaning. Use mild detergent and soft cloth for exterior. For interior, use oven cleaner or self-clean function (if available).</p>
<p><strong>CAUTION!</strong> Do not use abrasive cleaners or steel wool on glass or surfaces. Never pour water directly into oven.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>Complies with EU directives for low voltage and electromagnetic compatibility. CE marked. Manufactured under ISO 9001 quality standards. For support, visit www.beko.com or contact customer service at 1-800-000-0000.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Oven not heating</td><td>Power supply/function selection</td><td>Check power connection; ensure function and temperature are set correctly.</td></tr>
<tr><td>Display not working</td><td>Power/child lock</td><td>Check circuit breaker; disable child lock.</td></tr>
<tr><td>Uneven cooking</td><td>Rack position/function</td><td>Adjust rack to correct level; use fan function for even heat.</td></tr>
<tr><td>Door not closing properly</td><td>Obstruction/hinge</td><td>Check for food debris; ensure hinges are aligned.</td></tr>
<tr><td>Error code on display</td><td>Fault detection</td><td>Refer to manual for error code meaning; reset oven or call service.</td></tr>
</table>
<p><strong>Reset:</strong> Turn off power for 5 minutes, then restart.</p>
<p><strong>Service:</strong> 1-800-000-0000; www.beko.com</p>
<div style="text-align: center;">
Beko Built In Oven User Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
