<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Dishwasher DIN35322 Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Dishwasher DIN35322 Manual</h1>
<p>The Beko DIN35322 is a freestanding dishwasher featuring a stainless steel interior, 12 place settings capacity, 5 wash programs (including Intensive, Eco, and Quick), A++ energy rating, digital display, delay start timer, child lock, half load option, and adjustable upper basket. It operates on 220-240V, 50Hz. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Loading the Dishwasher</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Care & Maintenance</a>
<a href="#section10">9. Safety Information</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Stainless steel tub, digital control panel, upper and lower baskets, cutlery basket, detergent and rinse aid dispensers, water inlet and drain hoses.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Capacity</td><td>12 place settings</td></tr>
<tr><td>Energy Rating</td><td>A++ (energy efficient)</td></tr>
<tr><td>Wash Programs</td><td>5 programs including Intensive, Eco, Quick, Glass, and Auto</td></tr>
<tr><td>Delay Start</td><td>1-24 hour timer</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Half Load</td><td>Option for washing fewer dishes</td></tr>
<tr><td>Digital Display</td><td>Shows program time, delay start, and status</td></tr>
<tr><td>Adjustable Upper Basket</td><td>Height can be adjusted for taller items</td></tr>
<tr><td>Salt Indicator</td><td>Alerts when water softener salt is low</td></tr>
<tr><td>Rinse Aid Indicator</td><td>Alerts when rinse aid needs refilling</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure location is level and near water/drain connections.</p>
<ol>
<li>Connect water supply: Attach inlet hose to water tap (ensure filter is clean).</li>
<li>Connect drain hose: Place hose into sink or dedicated drain pipe (use hose clip).</li>
<li>Level the dishwasher: Adjust feet until unit is stable and level.</li>
<li>Plug into grounded power outlet (220-240V, 50Hz).</li>
</ol>
<p><strong>WARNING!</strong> Ensure water connections are tight to prevent leaks. Do not bend drain hose sharply.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, run an empty cycle to clean interior.</p>
<ol>
<li>Add salt: Fill water softener reservoir with special dishwasher salt.</li>
<li>Add rinse aid: Fill rinse aid dispenser to MAX line.</li>
<li>Select program: Choose Intensive program without dishes.</li>
<li>Start cycle: Close door and press Start/Pause.</li>
<li>Set language: If applicable, set display language via Settings menu.</li>
</ol>
<p><strong>CAUTION!</strong> Use only dishwasher salt and rinse aid. Do not use table salt.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> DIN35322</li>
<li><strong>Type:</strong> Freestanding Dishwasher</li>
<li><strong>Capacity:</strong> 12 place settings</li>
<li><strong>Energy Rating:</strong> A++</li>
<li><strong>Water Consumption:</strong> Approx. 9.5 liters per cycle (Eco program)</li>
<li><strong>Power Consumption:</strong> 0.78 kWh per cycle (Eco program)</li>
<li><strong>Noise Level:</strong> 49 dB</li>
<li><strong>Dimensions (HxWxD):</strong> 85 x 60 x 60 cm</li>
<li><strong>Voltage/Frequency:</strong> 220-240V, 50Hz</li>
<li><strong>Programs:</strong> Intensive, Eco, Quick (30 min), Glass, Auto</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: Power On/Off, Program Selection buttons, Delay Start, Half Load, Child Lock, Start/Pause.</p>
<p><strong>Programs:</strong> Intensive (for heavily soiled), Eco (energy saving), Quick (30 min for lightly soiled), Glass (for delicate), Auto (sensors soil level).</p>
<p>Settings: Delay Start (1-24 hrs), Child Lock (hold for 3 sec to activate), Salt/Rinse Aid indicator reset (hold respective button). Display shows remaining time, program, and alerts.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Loading the Dishwasher</h2>
<p>Proper loading ensures optimal cleaning.</p>
<ol>
<li>Scrape off large food residues (no pre-rinsing needed).</li>
<li>Lower basket: Plates, pots, pans (face inward).</li>
<li>Upper basket: Glasses, cups, bowls (angled downward).</li>
<li>Cutlery basket: Forks, knives, spoons (handles down).</li>
<li>Adjust upper basket height if needed for taller items.</li>
<li>Ensure spray arms can rotate freely.</li>
</ol>
<p><strong>Tip:</strong> Do not overload; place delicate items in upper basket.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Select program based on soil level and dish type.</p>
<ol>
<li>Add detergent: Fill main dispenser with powder/tablet (use recommended amount).</li>
<li>Select program: Press program button until desired program lights up.</li>
<li>Optional: Press Delay Start to set timer; press Half Load if basket not full.</li>
<li>Start: Close door firmly, press Start/Pause.</li>
<li>During cycle: Display shows remaining time; door locks automatically.</li>
<li>After cycle: Wait for cycle end beep; open door slightly to let steam escape.</li>
</ol>
<p><strong>WARNING!</strong> Do not open door during cycle; hot steam may cause burns.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Care & Maintenance</h2>
<p>Regular maintenance ensures longevity.</p>
<ul>
<li>Clean filter: Remove and rinse under water weekly.</li>
<li>Clean spray arms: Check for blockages monthly.</li>
<li>Descale: Run empty cycle with dishwasher cleaner every 2-3 months.</li>
<li>Exterior: Wipe with damp cloth; do not use abrasive cleaners.</li>
<li>Check salt and rinse aid: Refill when indicator lights.</li>
</ul>
<p><strong>CAUTION!</strong> Unplug before cleaning interior parts. Do not use harsh chemicals.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Safety Information</h2>
<p>Read all instructions before use.</p>
<ul>
<li>Connect to grounded outlet only.</li>
<li>Do not wash items soiled with flammable substances.</li>
<li>Keep children away from open dishwasher (hot surfaces).</li>
<li>Use only dishwasher detergent (not regular soap).</li>
<li>Do not operate if hose is kinked or damaged.</li>
</ul>
<p><strong>WARNING!</strong> Risk of electric shock if installed improperly. Contact qualified technician for installation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked; complies with EU directives for safety and electromagnetic compatibility. Energy label according to EU regulation 1059/2010. Waste electrical products must not be disposed of with household waste. Please recycle according to local regulations. For support, visit www.beko.com or contact customer service at 0333 207 9710 (UK).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Dishwasher not starting</td><td>Door not closed/power</td><td>Ensure door is firmly closed; check power outlet and fuse.</td></tr>
<tr><td>Poor cleaning results</td><td>Loading/detergent</td><td>Check loading; ensure spray arms rotate freely; use correct detergent amount.</td></tr>
<tr><td>Water not draining</td><td>Drain hose blocked</td><td>Check hose for kinks/blockages; clean filter.</td></tr>
<tr><td>Leaking water</td><td>Hose connections</td><td>Tighten inlet/drain hose connections; check door seal for debris.</td></tr>
<tr><td>Unusual noise</td><td>Foreign objects</td><td>Check for small items in pump or spray arms.</td></tr>
<tr><td>Salt/Rinse Aid indicator on</td><td>Low level</td><td>Refill salt or rinse aid; reset indicator (hold button 3 sec).</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then plug back in.</p>
<p><strong>Service:</strong> 0333 207 9710; www.beko.com</p>
<div style="text-align: center;">
Beko Dishwasher DIN35322 Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
