<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Dishwasher DIS25011 Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Dishwasher DIS25011 Manual</h1>
<p>The Beko DIS25011 is a freestanding dishwasher with 12 place settings, featuring 6 wash programs, A++ energy rating, 49 dB noise level, half load option, delay start, child lock, and salt/rinse aid indicators. Below are key sections for safety, features, installation, setup, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Loading the Dishwasher</a>
<a href="#section8">7. Using Detergents & Additives</a>
<a href="#section9">8. Programs & Cycles</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Control panel, Upper and lower baskets, Cutlery basket, Filter system, Salt container, Rinse aid dispenser, Water inlet and drain hoses.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Program Selection</td><td>6 wash programs including Intensive, Eco, Quick</td></tr>
<tr><td>Half Load Option</td><td>Reduces water and energy for smaller loads</td></tr>
<tr><td>Delay Start</td><td>Program start delay up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Salt Indicator</td><td>Alerts when water softener salt is low</td></tr>
<tr><td>Rinse Aid Indicator</td><td>Alerts when rinse aid needs refilling</td></tr>
<tr><td>Filter System</td><td>3-stage filtration for optimal cleaning</td></tr>
<tr><td>Adjustable Upper Basket</td><td>Height adjustable for taller items</td></tr>
<tr><td>Cutlery Basket</td><td>Removable basket with separate compartments</td></tr>
<tr><td>Acoustic Insulation</td><td>Reduced noise level at 49 dB</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure location is level and near water/drain connections.</p>
<ol>
<li>Position dishwasher: Place in desired location, ensure level using adjustable feet.</li>
<li>Connect water supply: Attach inlet hose to cold water tap (max pressure 1 MPa).</li>
<li>Connect drain hose: Ensure proper height (40-100 cm from floor) to prevent siphoning.</li>
<li>Electrical connection: Plug into grounded 220-240V, 50Hz outlet.</li>
<li>Remove transport materials: Take out shipping bolts and secure holes with caps.</li>
</ol>
<p><strong>WARNING!</strong> Dishwasher is heavy; use two people for handling. Ensure all connections are secure before first use.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, prepare dishwasher for operation.</p>
<ol>
<li>Fill salt container: Remove lower basket, twist open salt cap, fill with special dishwasher salt (first use: add 1 liter water).</li>
<li>Fill rinse aid: Open dispenser on door, fill to MAX line, close securely.</li>
<li>Run initial cycle: Select Intensive program without dishes to clean interior.</li>
<li>Adjust water hardness: Set according to local water hardness using program button combination.</li>
<li>Load test dishes: Arrange according to loading guidelines for optimal cleaning.</li>
</ol>
<p><strong>CAUTION!</strong> Only use dishwasher-specific salt in salt container. Never use table salt.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> DIS25011</li>
<li><strong>Type:</strong> Freestanding</li>
<li><strong>Place Settings:</strong> 12 standard place settings</li>
<li><strong>Energy Rating:</strong> A++</li>
<li><strong>Water Consumption:</strong> 9.5 liters per cycle (Eco program)</li>
<li><strong>Power Consumption:</strong> 0.78 kWh per cycle (Eco program)</li>
<li><strong>Noise Level:</strong> 49 dB</li>
<li><strong>Programs:</strong> 6 wash programs</li>
<li><strong>Dimensions (HxWxD):</strong> 85 x 60 x 60 cm</li>
<li><strong>Weight:</strong> 42 kg</li>
<li><strong>Voltage:</strong> 220-240V, 50Hz</li>
<li><strong>Max Inlet Water Pressure:</strong> 1 MPa</li>
<li><strong>Max Inlet Water Temperature:</strong> 60°C</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: Program selector, Start/Pause, Half Load, Delay Start, Child Lock, Salt and Rinse Aid indicators.</p>
<p><strong>Program Selection:</strong> Turn knob to select desired program. Available programs: Intensive (70°C), Eco (50°C), Normal (65°C), Quick (45°C), Glass (40°C), Rinse Only.</p>
<p><strong>Special Functions:</strong> Half Load button (reduces consumption), Delay Start (1-24 hours), Child Lock (press and hold Start for 3 seconds).</p>
<p><strong>Indicators:</strong> Salt indicator lights when salt is low. Rinse aid indicator lights when dispenser needs refilling. End indicator shows when cycle is complete.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Loading the Dishwasher</h2>
<p>Proper loading ensures optimal cleaning and drying results.</p>
<ol>
<li>Scrape off large food residues before loading.</li>
<li>Lower basket: Plates, pots, pans, lids. Face soiled surfaces toward center.</li>
<li>Upper basket: Glasses, cups, bowls, small plates. Angle items for proper drainage.</li>
<li>Cutlery basket: Forks and spoons handle down, knives handle up for safety.</li>
<li>Adjust upper basket: Lift to higher position for taller items in lower basket.</li>
<li>Ensure spray arms rotate freely without obstruction.</li>
</ol>
<p><strong>Tip:</strong> Do not overload. Water must reach all surfaces for effective cleaning.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Detergents & Additives</h2>
<p>Use only dishwasher-specific products for best results.</p>
<ol>
<li>Detergent: Fill main detergent dispenser according to water hardness and soil level (15-25g). Use tablets or powder.</li>
<li>Prewash detergent: For heavily soiled loads, add small amount to prewash compartment.</li>
<li>Rinse aid: Essential for spot-free drying. Adjust dispenser setting (1-6) based on water hardness.</li>
<li>Salt: Regenerates water softener. Refill when indicator lights (approximately every 20 cycles).</li>
</ol>
<p><strong>WARNING!</strong> Never use regular dish soap. It creates excessive suds that can damage the machine.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Programs & Cycles</h2>
<table>
<tr><th>Program</th><th>Temperature</th><th>Duration</th><th>Best For</th></tr>
<tr><td>Intensive</td><td>70°C</td><td>155 min</td><td>Heavily soiled pots, pans, baking dishes</td></tr>
<tr><td>Eco</td><td>50°C</td><td>195 min</td><td>Normally soiled dishes, energy saving</td></tr>
<tr><td>Normal</td><td>65°C</td><td>125 min</td><td>Daily use, mixed loads</td></tr>
<tr><td>Quick</td><td>45°C</td><td>35 min</td><td>Lightly soiled, quick refresh</td></tr>
<tr><td>Glass</td><td>40°C</td><td>85 min</td><td>Glassware, delicate items</td></tr>
<tr><td>Rinse Only</td><td>Cold</td><td>15 min</td><td>Rinsing without detergent</td></tr>
</table>
<p><strong>Half Load Option:</strong> Reduces water and energy by approximately 30% when loading only one basket.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Regular maintenance ensures optimal performance and longevity.</p>
<ol>
<li>Clean filter weekly: Remove lower basket, twist filter assembly counterclockwise, rinse under warm water.</li>
<li>Clean spray arms monthly: Remove by pulling upward, check for clogs in spray holes.</li>
<li>Wipe door seals: Clean with damp cloth to prevent mold and ensure proper sealing.</li>
<li>Clean interior: Run empty cycle with dishwasher cleaner every 2-3 months.</li>
<li>Exterior: Wipe with soft damp cloth, mild detergent if needed.</li>
</ol>
<p><strong>CAUTION!</strong> Unplug before any maintenance. Never use abrasive cleaners or scouring pads.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked: Complies with European Directives. Energy label according to EU regulation 1059/2010. Waste electrical products should not be disposed of with household waste. Please recycle where facilities exist. For support, visit www.beko.com or contact local Beko service center. Serial number located on rating plate inside door.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Dishwasher won't start</td><td>Door not closed properly, no power</td><td>Ensure door is latched, check power outlet, circuit breaker</td></tr>
<tr><td>Poor cleaning results</td><td>Overloaded, wrong program, clogged filter</td><td>Reduce load, select appropriate program, clean filter</td></tr>
<tr><td>Water not draining</td><td>Drain hose kinked, filter clogged</td><td>Check hose path, clean filter system</td></tr>
<tr><td>White residue on dishes</td><td>Insufficient rinse aid, water too hard</td><td>Refill rinse aid, adjust dispenser setting, check salt level</td></tr>
<tr><td>Leaking water</td><td>Overfilling, damaged door seal</td><td>Check water inlet valve, inspect and clean door seal</td></tr>
<tr><td>Unusual noise</td><td>Spray arm hitting dishes, foreign object</td><td>Rearrange load, check for small objects in pump area</td></tr>
<tr><td>Salt indicator stays on</td><td>Salt container empty, water hardness setting incorrect</td><td>Refill salt, check and adjust water hardness setting</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes to reset electronic control.</p>
<p><strong>Service:</strong> For persistent issues, contact authorized Beko service: www.beko.com/support</p>
<div style="text-align: center;">
Beko Dishwasher DIS25011 User Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
