<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>beko dishwasher DIS28123 manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>beko dishwasher DIS28123 manual</h1>
<p>The Beko DIS28123 is a freestanding dishwasher with 14 place settings, A++ energy rating, 49 dB noise level, and multiple wash programs. It features electronic controls, delay start, half load option, child lock, and salt/rinse aid indicators. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Loading the Dishwasher</a>
<a href="#section8">7. Using Detergents and Additives</a>
<a href="#section9">8. Care & Cleaning</a>
<a href="#section10">9. Safety Information</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Electronic control panel, upper and lower baskets, cutlery basket, filter system, salt container, rinse aid dispenser.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Energy Rating</td><td>A++ (Energy Efficient)</td></tr>
<tr><td>Place Settings</td><td>14 standard place settings</td></tr>
<tr><td>Noise Level</td><td>49 dB (Quiet operation)</td></tr>
<tr><td>Wash Programs</td><td>8 programs including Eco, Intensive, Quick</td></tr>
<tr><td>Delay Start</td><td>Up to 24 hours delay timer</td></tr>
<tr><td>Half Load Option</td><td>Reduces water and energy for smaller loads</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Salt/Rinse Aid Indicators</td><td>LED indicators for refill reminders</td></tr>
<tr><td>Display</td><td>Digital display with remaining time</td></tr>
<tr><td>Dimensions (HxWxD)</td><td>85 x 60 x 60 cm</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure location is level and near water/drain connections.</p>
<ol>
<li>Remove transit materials: Take out all polystyrene blocks and tape.</li>
<li>Connect water supply: Attach inlet hose to cold water tap (max pressure 1 MPa).</li>
<li>Connect drain hose: Ensure proper height (40-100 cm from floor) to prevent siphoning.</li>
<li>Level the appliance: Adjust feet until dishwasher is stable and level.</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Only connect to cold water supply. Ensure electrical socket is easily accessible.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, prepare the dishwasher for operation.</p>
<ol>
<li>Fill salt container: Remove lower basket, unscrew salt cap, fill with 1 kg dishwasher salt, replace cap.</li>
<li>Fill rinse aid dispenser: Open dispenser lid, fill to MAX line with rinse aid, close lid.</li>
<li>Run initial cycle: Select Intensive program without dishes to clean interior and remove manufacturing residues.</li>
<li>Set water hardness: Consult manual table; press and hold P1 and P3 buttons for 3 seconds to enter setting mode.</li>
</ol>
<p><strong>CAUTION!</strong> Use only dishwasher salt in salt container. Do not use table salt.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> DIS28123</li>
<li><strong>Type:</strong> Freestanding Dishwasher</li>
<li><strong>Energy Consumption:</strong> 0.95 kWh per cycle (Eco program)</li>
<li><strong>Water Consumption:</strong> 10 liters per cycle (Eco program)</li>
<li><strong>Programs:</strong> Eco 50°C, Intensive 70°C, Quick 45°C, Glass 40°C, Auto, Rinse, Prewash</li>
<li><strong>Delay Timer:</strong> 3, 6, 9 hours or 24-hour delay</li>
<li><strong>Power Supply:</strong> 220-240V, 50Hz</li>
<li><strong>Power Consumption:</strong> 2000 W</li>
<li><strong>Inlet Water Pressure:</strong> 0.03-1 MPa</li>
<li><strong>Weight:</strong> 42 kg</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: ON/OFF button, program selection buttons, delay start, half load, child lock, start/pause.</p>
<p><strong>Program Selection:</strong> Press program button repeatedly to cycle through options. Selected program LED lights up.</p>
<p><strong>Delay Start:</strong> Press delay button to set 3, 6, 9, or 24-hour delay. Display shows remaining delay time.</p>
<p><strong>Half Load:</strong> Press half load button when washing fewer dishes to save resources.</p>
<p><strong>Child Lock:</strong> Press and hold start/pause button for 3 seconds to activate/deactivate.</p>
<p><strong>Display Symbols:</strong> Salt indicator (red), Rinse aid (green), End of cycle (green), Door open (flashing).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Loading the Dishwasher</h2>
<p>Proper loading ensures optimal cleaning results.</p>
<ol>
<li>Scrape off large food residues before loading.</li>
<li>Upper basket: Cups, glasses, small plates, plastic items (top rack only).</li>
<li>Lower basket: Plates, bowls, pots, pans. Face soiled surfaces toward center.</li>
<li>Cutlery basket: Place knives pointing down, spoons and forks mixed for separation.</li>
<li>Adjust upper basket height: Lift both sides simultaneously to raise/lower.</li>
<li>Ensure spray arms rotate freely and items don't block them.</li>
</ol>
<p><strong>Tip:</strong> Do not overload. Leave space between items for water circulation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Detergents and Additives</h2>
<p>Use only dishwasher-specific products.</p>
<ol>
<li>Detergent: Fill main dispenser with powder, tablet, or gel. Use amount according to water hardness and soil level.</li>
<li>Rinse Aid: Automatically dispensed during final rinse. Adjust dosage level (1-5) via dial under dispenser lid.</li>
<li>Salt: Regenerates water softener. Refill when salt indicator lights (approximately every 20 cycles).</li>
<li>Prewash Detergent: For heavily soiled loads, add small amount to prewash compartment.</li>
</ol>
<p><strong>WARNING!</strong> Do not use regular washing-up liquid. It creates excessive suds.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Care & Cleaning</h2>
<p>Regular maintenance ensures optimal performance.</p>
<ol>
<li>Clean filters: Remove lower basket, twist filter assembly counterclockwise, rinse under tap weekly.</li>
<li>Clean spray arms: Remove by pulling upward, check nozzles for blockages, rinse monthly.</li>
<li>Clean door seal: Wipe with damp cloth to remove food residues.</li>
<li>Descale: Run empty cycle with dishwasher cleaner every 2-3 months in hard water areas.</li>
<li>Exterior: Wipe with soft damp cloth; do not use abrasive cleaners.</li>
</ol>
<p><strong>CAUTION!</strong> Unplug before cleaning. Never use steam cleaners.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Safety Information</h2>
<p>Read all instructions before use. Keep children away from open door (risk of hot steam).</p>
<ul>
<li>Connect to properly grounded outlet only.</li>
<li>Do not open door during operation; wait until steam dissipates.</li>
<li>Sharp items should be placed pointing downward.</li>
<li>Only use detergents specifically for dishwashers.</li>
<li>Disconnect power before any maintenance.</li>
<li>Do not sit or stand on open door.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>This appliance complies with EU Directive 2014/35/EU (Low Voltage Directive) and 2014/30/EU (EMC Directive). Waste electrical products should not be disposed of with household waste. Please recycle where facilities exist. Check local regulations for disposal of packaging materials. For support, visit www.beko.com or contact your local Beko service center.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Dishwasher won't start</td><td>Power supply, door not closed</td><td>Check plug socket; ensure door is firmly closed; child lock activated.</td></tr>
<tr><td>Poor cleaning results</td><td>Loading, filters, detergent</td><td>Check loading; clean filters; use correct detergent amount; check spray arms.</td></tr>
<tr><td>Water not draining</td><td>Drain hose blockage</td><td>Check drain hose for kinks; clean filter; ensure proper installation height.</td></tr>
<tr><td>Salt indicator stays on</td><td>Salt container empty</td><td>Fill salt container; run short program to flush salt into softener.</td></tr>
<tr><td>Leaking water</td><td>Inlet hose, door seal</td><td>Check hose connections; inspect door seal for damage; ensure dishwasher is level.</td></tr>
<tr><td>Unusual noise</td><td>Spray arm obstruction</td><td>Check for items blocking spray arms; ensure baskets are properly positioned.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart.</p>
<p><strong>Service:</strong> Contact authorized Beko service at www.beko.com or local service center.</p>
<div style="text-align: center;">
beko dishwasher DIS28123 manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
