<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Dishwasher DIT28330 Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Dishwasher DIT28330 Manual</h1>
<p>The Beko DIT28330 is a freestanding dishwasher with a 14-place setting capacity, featuring an A++ energy rating, 12 washing programs including Eco, Intensive, and Quick Wash, delay start timer, child lock, half-load option, and AquaIntense technology for improved cleaning. It includes a salt and rinse aid indicator, adjustable upper basket, and cutlery basket. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Loading the Dishwasher</a>
<a href="#section8">7. Using Programs & Functions</a>
<a href="#section9">8. Care & Maintenance</a>
<a href="#section10">9. Regulatory Information</a>
<a href="#section11">10. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Control panel with digital display, adjustable upper basket, lower basket, cutlery basket, detergent dispenser, salt container, rinse aid dispenser, and filter system.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Capacity</td><td>14 place settings</td></tr>
<tr><td>Energy Rating</td><td>A++</td></tr>
<tr><td>Washing Programs</td><td>12 programs including Eco, Intensive, Quick 30'</td></tr>
<tr><td>Delay Start</td><td>Timer up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Safety lock for control panel</td></tr>
<tr><td>Half Load</td><td>Option for washing fewer dishes</td></tr>
<tr><td>AquaIntense</td><td>Enhanced spray system for better cleaning</td></tr>
<tr><td>Salt & Rinse Aid Indicator</td><td>LED indicators for refill reminders</td></tr>
<tr><td>Adjustable Upper Basket</td><td>Height adjustable for taller items</td></tr>
<tr><td>Digital Display</td><td>Shows program time and status</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure location is level and near water/drain connections.</p>
<ol>
<li>Connect water supply: Attach inlet hose to water tap (ensure filter is clean).</li>
<li>Connect drain hose: Place hose into sink or dedicated drain pipe (max height 1m).</li>
<li>Level the appliance: Adjust feet to ensure dishwasher is stable and level.</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Ensure water and electrical connections are secure before first use. Do not kink hoses.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first wash, prepare the dishwasher.</p>
<ol>
<li>Fill salt container: Remove lower basket, unscrew salt cap, fill with dishwasher salt (first time add 1L water).</li>
<li>Fill rinse aid dispenser: Open dispenser lid, fill to MAX line, close securely.</li>
<li>Add detergent: Use powder or tablet in detergent dispenser.</li>
<li>Run initial empty cycle: Select Intensive program without dishes to clean interior.</li>
</ol>
<p><strong>CAUTION!</strong> Use only dishwasher-specific salt and rinse aid. Do not mix with detergent.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Type:</strong> Freestanding dishwasher.</li>
<li><strong>Capacity:</strong> 14 place settings.</li>
<li><strong>Energy Class:</strong> A++.</li>
<li><strong>Water Consumption:</strong> Approx. 10L per cycle (Eco program).</li>
<li><strong>Power Consumption:</strong> Approx. 0.95 kWh per cycle (Eco program).</li>
<li><strong>Noise Level:</strong> 49 dB(A).</li>
<li><strong>Programs:</strong> 12 including Auto, Eco, Intensive, Quick 30', Glass, Delicate.</li>
<li><strong>Dimensions (HxWxD):</strong> 85cm x 60cm x 60cm.</li>
<li><strong>Power Supply:</strong> 220-240V, 50Hz.</li>
<li><strong>Inlet Water Pressure:</strong> 0.5-10 bar.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: POWER button, Program selector knob, Delay Start button, Half Load button, Child Lock button, Start/Pause button.</p>
<p><strong>Display Icons:</strong> Salt indicator, Rinse aid indicator, Program time remaining, Delay start active, Child lock active.</p>
<p>Program Selection: Turn knob to desired program (Eco, Intensive, Quick 30', etc.). Delay Start: Press button, use +/- to set hours (1-24). Half Load: Press to activate for fewer dishes. Child Lock: Press and hold for 3 seconds to lock/unlock controls. Start/Pause: Start program or pause during operation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Loading the Dishwasher</h2>
<p>Proper loading ensures optimal cleaning.</p>
<ol>
<li>Scrape off large food residues (no need to pre-rinse).</li>
<li>Lower basket: For plates, pots, pans. Adjustable tines for different sizes.</li>
<li>Upper basket: For glasses, cups, small bowls. Height adjustable.</li>
<li>Cutlery basket: Place knives, forks, spoons with handles down (sharp items pointing down).</li>
<li>Ensure spray arms can rotate freely; do not block with large items.</li>
</ol>
<p><strong>Tip:</strong> Place heavily soiled items facing the center spray arm for better cleaning.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Programs & Functions</h2>
<p>Select program based on soil level and dish type.</p>
<ol>
<li>Eco: Energy-efficient for normally soiled dishes (approx. 3 hours).</li>
<li>Intensive: For heavily soiled pots and pans (75°C).</li>
<li>Quick 30': Fast wash for lightly soiled dishes (30 minutes).</li>
<li>Auto: Automatically adjusts time/temp based on soil sensors.</li>
<li>Glass: Gentle wash for delicate glassware (45°C).</li>
<li>Delicate: For china and fine ceramics.</li>
<li>Half Load: Use with half load button for fewer dishes (saves water/energy).</li>
<li>Delay Start: Set to start later (e.g., during off-peak hours).</li>
</ol>
<p><strong>WARNING!</strong> Do not open door during hot wash cycles; steam may cause burns.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Care & Maintenance</h2>
<p>Regular maintenance ensures longevity and performance.</p>
<ol>
<li>Clean filter: Remove lower basket, twist and lift out filter assembly, rinse under water weekly.</li>
<li>Check spray arms: Ensure holes are not clogged; rotate freely.</li>
<li>Refill salt: When salt indicator lights, add dishwasher salt to container.</li>
<li>Refill rinse aid: When rinse aid indicator lights, fill dispenser.</li>
<li>Exterior cleaning: Wipe with damp cloth; do not use abrasive cleaners.</li>
<li>Monthly cleaning: Run empty cycle with dishwasher cleaner or vinegar to remove limescale.</li>
</ol>
<p><strong>CAUTION!</strong> Unplug before cleaning interior components. Do not use sharp objects to clean spray arms.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Regulatory Information</h2>
<p>CE marked; complies with EU directives for safety and electromagnetic compatibility. Energy label according to EU regulation 2019/2017. Waste electrical products must not be disposed of with household waste. Please recycle according to local regulations. For support, visit www.beko.com or contact your local Beko service center.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Dishwasher not starting</td><td>Power/door</td><td>Check power plug; ensure door is closed properly; check child lock.</td></tr>
<tr><td>Poor cleaning results</td><td>Loading/filter/detergent</td><td>Rearrange dishes; clean filter; use correct detergent amount; check spray arms.</td></tr>
<tr><td>Water not draining</td><td>Drain hose clogged</td><td>Check drain hose for kinks/clogs; clean filter.</td></tr>
<tr><td>Salt indicator on</td><td>Salt low</td><td>Refill salt container; ensure cap is tight.</td></tr>
<tr><td>Rinse aid indicator on</td><td>Rinse aid low</td><td>Refill rinse aid dispenser.</td></tr>
<tr><td>Unusual noise</td><td>Spray arm obstruction</td><td>Check for dishes blocking spray arms; ensure spray arms rotate freely.</td></tr>
<tr><td>Leaking water</td><td>Hose connections</td><td>Check inlet/drain hose connections; ensure door seal is clean and intact.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart.</p>
<p><strong>Service:</strong> Contact authorized Beko service; www.beko.com</p>
<div style="text-align: center;">
Beko Dishwasher DIT28330 Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
