<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Dishwasher FGS310 Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Dishwasher FGS310 Manual</h1>
<p>The Beko FGS310 is a freestanding dishwasher with a 12-place setting capacity, featuring 6 wash programs, A++ energy rating, 49 dB noise level, half-load option, delay timer up to 24 hours, child lock, and salt/rinse aid indicators. This manual covers safety instructions, installation, program selection, daily use, maintenance, and troubleshooting for optimal performance.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Loading the Dishwasher</a>
<a href="#section8">7. Using Detergents & Additives</a>
<a href="#section9">8. Care & Maintenance</a>
<a href="#section10">9. Safety Features</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Control panel with digital display, upper and lower baskets, cutlery basket, filter system, salt container, rinse aid dispenser, inlet and drain hoses.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Wash Programs</td><td>6 programs including Intensive, Eco, Quick, Glass, 90 Minute, and Rinse</td></tr>
<tr><td>Capacity</td><td>12 standard place settings</td></tr>
<tr><td>Energy Rating</td><td>A++ (Energy efficient)</td></tr>
<tr><td>Noise Level</td><td>49 dB (Quiet operation)</td></tr>
<tr><td>Half Load Option</td><td>Eco wash for fewer dishes</td></tr>
<tr><td>Delay Timer</td><td>Program start delay up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Salt & Rinse Aid Indicators</td><td>LED alerts for refilling</td></tr>
<tr><td>Display</td><td>Digital display showing time and status</td></tr>
<tr><td>Dimensions (HxWxD)</td><td>85 x 60 x 60 cm</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure location is level, near water/drain connections.</p>
<ol>
<li>Position dishwasher: Place on stable, level floor near sink.</li>
<li>Connect water supply: Attach inlet hose to cold water tap (max pressure 1 MPa).</li>
<li>Connect drain hose: Secure to sink or waste pipe (min height 40 cm).</li>
<li>Electrical connection: Plug into grounded 220-240V, 50Hz outlet.</li>
<li>Adjust feet: Level the appliance using adjustable front feet.</li>
</ol>
<p><strong>WARNING!</strong> Do not use extension cords. Ensure water connections are tight to prevent leaks.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, prepare dishwasher and set basic functions.</p>
<ol>
<li>Remove transport materials: Take out all interior packaging and transit bolts.</li>
<li>Fill salt container: Add 1 kg of special dishwasher salt (first use requires water filling).</li>
<li>Fill rinse aid: Pour into dispenser (max level marked).</li>
<li>Run empty wash: Select Intensive program without dishes to clean interior.</li>
<li>Set water hardness: Adjust dial inside salt container according to local water hardness.</li>
</ol>
<p><strong>CAUTION!</strong> Only use dishwasher salt and rinse aid designed for dishwashers.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko FGS310</li>
<li><strong>Type:</strong> Freestanding Dishwasher</li>
<li><strong>Capacity:</strong> 12 place settings</li>
<li><strong>Programs:</strong> 6 wash programs</li>
<li><strong>Energy Class:</strong> A++</li>
<li><strong>Water Consumption:</strong> 10 L per cycle (Eco program)</li>
<li><strong>Power Consumption:</strong> 0.78 kWh per cycle (Eco program)</li>
<li><strong>Voltage/Frequency:</strong> 220-240V, 50Hz</li>
<li><strong>Water Pressure:</strong> 0.03 - 1 MPa</li>
<li><strong>Warranty:</strong> 2 years parts and labor</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: POWER button, Program selection buttons, Delay Timer, Half Load, Start/Pause, Child Lock.</p>
<p><strong>Program Guide:</strong></p>
<table>
<tr><th>Program</th><th>Temp (°C)</th><th>Time</th><th>Use For</th></tr>
<tr><td>Intensive</td><td>70</td><td>155 min</td><td>Heavily soiled pots/pans</td></tr>
<tr><td>Eco</td><td>50</td><td>200 min</td><td>Normally soiled dishes (energy saving)</td></tr>
<tr><td>Quick</td><td>45</td><td>30 min</td><td>Lightly soiled, quick wash</td></tr>
<tr><td>Glass</td><td>40</td><td>85 min</td><td>Glassware, delicate items</td></tr>
<tr><td>90 Minute</td><td>65</td><td>90 min</td><td>Daily wash, balanced</td></tr>
<tr><td>Rinse</td><td>Cold</td><td>15 min</td><td>Rinse only, no detergent</td></tr>
</table>
<p>Additional Functions: Delay Timer (1-24 hours), Half Load (reduces water use), Child Lock (press and hold Start for 3 seconds).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Loading the Dishwasher</h2>
<p>Proper loading ensures optimal cleaning and drying.</p>
<ol>
<li>Scrape off large food residues before loading.</li>
<li>Lower basket: Plates, bowls, pots, pans (face center, avoid nesting).</li>
<li>Upper basket: Glasses, cups, saucers, small bowls (angled downward).</li>
<li>Cutlery basket: Place knives (blades down), spoons/forks mixed for separation.</li>
<li>Ensure spray arms rotate freely; no items blocking them.</li>
<li>Plastic items on upper rack only (away from heating element).</li>
</ol>
<p><strong>Tip:</strong> Refer to loading diagrams on inner door for optimal arrangement.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Detergents & Additives</h2>
<p>Use only dishwasher-specific products.</p>
<ol>
<li>Detergent: Fill main dispenser (15-25 g for normal soil). Use tablets/powder/gel.</li>
<li>Rinse Aid: Fill dispenser until MAX indicator; adjust dosage (1-6) via dial.</li>
<li>Salt: Fill salt container when indicator light comes on (only for models with water softener).</li>
<li>Pre-wash: For heavily soiled loads, add small amount to pre-wash chamber.</li>
</ol>
<p><strong>WARNING!</strong> Do not use regular washing-up liquid; it causes excessive suds.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Care & Maintenance</h2>
<p>Regular maintenance ensures longevity and performance.</p>
<ol>
<li>Clean filter: Remove and rinse under water weekly.</li>
<li>Clean spray arms: Check for blockages monthly.</li>
<li>Descale: Run empty with dishwasher cleaner every 2 months.</li>
<li>Wipe door seals: Clean with damp cloth to prevent leaks.</li>
<li>Check drain hose: Ensure no kinks or blockages.</li>
</ol>
<p><strong>CAUTION!</strong> Unplug before maintenance. Do not use abrasive cleaners.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Safety Features</h2>
<p>Child Lock: Locks control panel (activate by holding Start 3 seconds). Door Safety: Automatically stops if door opened during cycle. Overflow Protection: Float switch stops water if detected. Thermal Cut-out: Prevents overheating.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked. Complies with EU directives for safety (EN 60335-1, EN 60335-2-5) and electromagnetic compatibility (EN 55014-1, EN 55014-2). Energy label according to EU regulation 1059/2010. Waste disposal: Follow local regulations for WEEE. For support, visit www.beko.com or contact 0333 207 9710 (UK).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Dishwasher won't start</td><td>Power/door</td><td>Check plug, fuse, power; ensure door closed properly.</td></tr>
<tr><td>Poor cleaning results</td><td>Loading/detergent</td><td>Improve loading; use correct amount of fresh detergent; clean filter.</td></tr>
<tr><td>Water not draining</td><td>Drain hose/filter</td><td>Check hose for kinks; clean filter; ensure drain height correct.</td></tr>
<tr><td>Leaking water</td><td>Door seal/hose</td><td>Check door seal for debris; tighten hose connections; level appliance.</td></tr>
<tr><td>Noise during operation</td><td>Spray arm/items</td><td>Ensure spray arms rotate freely; check for items touching spray arm.</td></tr>
<tr><td>Salt/Rinse Aid light on</td><td>Low level</td><td>Refill salt container or rinse aid dispenser.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart.</p>
<p><strong>Service:</strong> 0333 207 9710; www.beko.com</p>
<div style="text-align: center;">
Beko Dishwasher FGS310 Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
