<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Double Oven Instruction Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Double Oven Instruction Manual</h1>
<p>The Beko Double Oven is a versatile kitchen appliance featuring two independent cooking cavities, multiple heating functions (fan, conventional, grill, defrost), digital timer and temperature controls, interior oven light, removable door glass for cleaning, telescopic runners for easy access, and energy-efficient operation. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Cooking Functions</a>
<a href="#section8">7. Cleaning & Maintenance</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Upper and lower oven cavities, Control Panel, Digital Display, Interior Light, Removable Door Glass, Telescopic Runners, Grill Element, Fan, Oven Shelves.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Upper Oven</td><td>Main cooking cavity with multiple functions</td></tr>
<tr><td>Lower Oven</td><td>Secondary cavity for additional cooking capacity</td></tr>
<tr><td>Control Panel</td><td>Digital touch controls for both ovens</td></tr>
<tr><td>Digital Display</td><td>Shows time, temperature, and selected function</td></tr>
<tr><td>Interior Light</td><td>Illuminates oven interior for visibility</td></tr>
<tr><td>Removable Door Glass</td><td>Easy cleaning of oven door</td></tr>
<tr><td>Telescopic Runners</td><td>Smooth extension of oven shelves</td></tr>
<tr><td>Grill Element</td><td>For grilling and browning</td></tr>
<tr><td>Fan</td><td>For even heat distribution in fan-assisted cooking</td></tr>
<tr><td>Oven Shelves</td><td>Removable and adjustable for different cookware</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure proper electrical connection.</p>
<ol>
<li>Position the oven: Place in a stable, level kitchen cabinet cutout.</li>
<li>Electrical connection: Must be performed by a qualified electrician. Connect to appropriate power supply.</li>
<li>Secure the oven: Fix into cabinet using provided screws.</li>
<li>Remove protective film: Peel off any protective coatings from surfaces.</li>
</ol>
<p><strong>WARNING!</strong> Oven is heavy; use two people for lifting. Ensure electrical supply matches specifications.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Power on oven; perform initial setup.</p>
<ol>
<li>Set clock: Press CLOCK button and adjust time using +/- buttons.</li>
<li>Select language: In settings menu, choose preferred language.</li>
<li>Run initial heating: Heat both ovens empty at 200°C for 30 minutes to remove manufacturing residues.</li>
<li>Familiarize with controls: Review function symbols and temperature settings.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure adequate ventilation around oven. Keep flammable materials away.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko Double Oven.</li>
<li><strong>Oven Capacity:</strong> Upper: 60L, Lower: 40L.</li>
<li><strong>Functions:</strong> Fan, Conventional, Grill, Defrost, Bottom Heat, Fan Grill.</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50Hz.</li>
<li><strong>Max Temperature:</strong> 250°C.</li>
<li><strong>Timer:</strong> Digital, up to 120 minutes.</li>
<li><strong>Energy Rating:</strong> A+ for energy efficiency.</li>
<li><strong>Dimensions (HxWxD):</strong> 895 x 595 x 570 mm.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Access controls via touch panel. Functions: Upper Oven Select, Lower Oven Select, Temperature Adjust, Timer Set, Function Select (Fan, Grill, etc.), Light On/Off.</p>
<p><strong>Display Indicators:</strong> Clock, Timer countdown, Temperature, Selected function icon.</p>
<p>Temperature Range: 50°C to 250°C. Timer: Can be set for cooking duration or delayed start. Functions: Upper Oven - Fan, Conventional, Grill, Defrost; Lower Oven - Fan, Conventional, Bottom Heat. Safety: Child lock available (press and hold LOCK for 3 seconds).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Cooking Functions</h2>
<p>Upper Oven: Fan (for even baking/roasting), Conventional (top and bottom heat), Grill (for browning), Defrost (gentle fan for thawing). Lower Oven: Fan, Conventional, Bottom Heat (for slow cooking).</p>
<ol>
<li>Select oven: Press UPPER or LOWER button.</li>
<li>Choose function: Press FUNCTION button and select desired symbol.</li>
<li>Set temperature: Use +/- buttons to adjust.</li>
<li>Set timer: Press TIMER, set duration, press START.</li>
<li>Monitor cooking: Display shows remaining time.</li>
<li>End cooking: Oven beeps when timer ends; turn off manually or use auto shut-off.</li>
</ol>
<p><strong>Tip:</strong> Preheat oven for 10-15 minutes for best results. Use lower shelf for crisping, middle for baking.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Cleaning & Maintenance</h2>
<p>Regular cleaning ensures longevity and performance.</p>
<ol>
<li>Cool down: Ensure oven is completely cool before cleaning.</li>
<li>Remove shelves and runners: Wash in warm soapy water.</li>
<li>Clean interior: Use mild detergent and soft cloth. Avoid abrasive cleaners.</li>
<li>Door glass: Remove by unlocking clips, clean separately.</li>
<li>Exterior: Wipe with damp cloth; dry immediately.</li>
<li>Pyrolytic cleaning (if available): Run self-cleaning cycle as per manual.</li>
</ol>
<p><strong>WARNING!</strong> Do not use steam cleaners. Never immerse oven in water.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Child Lock: Disables controls to prevent accidental operation. Overheat Protection: Automatically cuts power if overheating detected. Cool-Touch Door: Stays cool during operation. Auto Shut-Off: Turns off after timer ends.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug or switch off power before cleaning. Use only recommended cleaners.</p>
<p><strong>CAUTION!</strong> Avoid harsh chemicals; do not spray directly on controls. Keep vents clear.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>Complies with EU safety and energy standards (CE marked). Manufactured under ISO 9001 quality standards. Copyright © Beko plc. For support, visit www.beko.com or contact customer service at 0333 207 9710 (UK).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Oven not heating</td><td>Power supply/function selection</td><td>Check power connection; ensure correct function and temperature set.</td></tr>
<tr><td>Display not working</td><td>Power/child lock</td><td>Check circuit breaker; disable child lock (hold LOCK).</td></tr>
<tr><td>Uneven cooking</td><td>Shelves positioning</td><td>Adjust shelf to correct height; preheat oven sufficiently.</td></tr>
<tr><td>Door not closing properly</td><td>Obstructions/hinges</td><td>Check for food debris; ensure door is aligned.</td></tr>
<tr><td>Unusual noises</td><td>Fan/expansion</td><td>Normal during heating/cooling; if persistent, contact service.</td></tr>
</table>
<p><strong>Reset:</strong> Turn off power for 5 minutes, then restart.</p>
<p><strong>Service:</strong> 0333 207 9710; www.beko.com</p>
<div style="text-align: center;">
Beko Double Oven Instruction Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
