<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Double Oven KDC653W Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Double Oven KDC653W Manual</h1>
<p>The Beko KDC653W is a 60cm wide double oven with multifunction capabilities, featuring a main oven with fan cooking, conventional heating, grill, and defrost functions, plus a smaller second oven with grill and conventional heating. It includes a programmable timer, interior oven light, catalytic liners for easier cleaning, and a glass door with a cool-touch handle. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Cooking Functions</a>
<a href="#section8">7. Cleaning & Maintenance</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Regulatory Information</a>
<a href="#section11">10. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Main oven with multifunction selector, second oven with grill, electronic timer with clock, oven interior light, catalytic liners, glass door with cool-touch handle, and removable side racks.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Main Oven</td><td>Multifunction: Fan, Conventional, Grill, Defrost, Fan Grill</td></tr>
<tr><td>Second Oven</td><td>Conventional heating and grill functions</td></tr>
<tr><td>Timer</td><td>Programmable electronic timer with automatic cooking</td></tr>
<tr><td>Interior Light</td><td>Illuminates oven interior when door is opened</td></tr>
<tr><td>Catalytic Liners</td><td>Side panels that absorb grease and splashes for easier cleaning</td></tr>
<tr><td>Cool-Touch Door</td><td>Double glazed glass door stays cool during operation</td></tr>
<tr><td>Removable Side Racks</td><td>Adjustable and removable for flexible cooking</td></tr>
<tr><td>Energy Rating</td><td>A-rated for energy efficiency</td></tr>
<tr><td>Child Lock</td><td>Safety feature to prevent accidental operation</td></tr>
<tr><td>Power Indicator</td><td>Shows when oven is heating</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure installation space meets requirements.</p>
<ol>
<li>Position the oven: Place in a suitable kitchen cabinet cut-out (60cm width).</li>
<li>Electrical connection: Must be installed by a qualified electrician. Connect to appropriate power supply (220-240V, 50Hz).</li>
<li>Ventilation: Ensure adequate space around oven for air circulation.</li>
<li>Secure the oven: Fix into cabinet using screws provided.</li>
</ol>
<p><strong>WARNING!</strong> Oven is heavy; use two people for lifting. Disconnect power before installation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>After installation, perform initial setup.</p>
<ol>
<li>Set the clock: Press and hold CLOCK button, use +/- to set time.</li>
<li>Remove packaging: Take off all protective films and transit bolts.</li>
<li>Initial heating: Run empty main oven at 200°C for 60 minutes to burn off manufacturing residues.</li>
<li>Familiarize with controls: Review function selector and timer operation.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure oven is properly installed and ventilated before first use.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Dimensions:</strong> 60cm (W) x 60cm (H) x 56cm (D).</li>
<li><strong>Capacity:</strong> Main oven 71L, Second oven 34L.</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50Hz.</li>
<li><strong>Power Consumption:</strong> Main oven 2.3kW, Second oven 1.8kW.</li>
<li><strong>Functions:</strong> Fan, Conventional, Grill, Defrost, Fan Grill.</li>
<li><strong>Timer:</strong> Electronic programmable up to 120 minutes.</li>
<li><strong>Energy Rating:</strong> A (EU energy label).</li>
<li><strong>Door:</strong> Double glazed glass with cool-touch handle.</li>
<li><strong>Cleaning:</strong> Catalytic liners, enamel interior.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control panel includes function selector knob, temperature knob, timer buttons, and power indicator.</p>
<p><strong>Main Controls:</strong> Function selector (Fan, Conventional, Grill, Defrost, Fan Grill), Temperature knob (50-250°C), Timer (SET, +/- buttons), Clock, Child Lock.</p>
<p>Timer Programming: Press SET, use +/- to set cooking duration, press SET again to confirm. Automatic shut-off when time ends. Child Lock: Press and hold CLOCK for 3 seconds to activate/deactivate. Temperature Settings: Refer to cooking guide for recommended temperatures.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Cooking Functions</h2>
<p>Main oven offers multiple cooking modes.</p>
<ol>
<li>Fan Cooking: Circulates hot air for even cooking; reduce temperature by 20°C from conventional recipes.</li>
<li>Conventional Heating: Top and bottom heating elements.</li>
<li>Grill: Upper heating element for grilling meats and toasting.</li>
<li>Fan Grill: Combines fan with grill for faster browning.</li>
<li>Defrost: Uses fan without heat to thaw food.</li>
<li>Second Oven: Use for smaller dishes or as additional cooking space.</li>
</ol>
<p><strong>Tip:</strong> Preheat oven for 10-15 minutes before cooking for best results.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Cleaning & Maintenance</h2>
<p>Always disconnect power before cleaning.</p>
<ol>
<li>Interior: Wipe with damp cloth; catalytic liners absorb grease (replace if damaged).</li>
<li>Door: Clean glass with mild detergent; do not use abrasive cleaners.</li>
<li>Racks and trays: Remove and wash in warm soapy water.</li>
<li>Exterior: Wipe with soft damp cloth; avoid harsh chemicals.</li>
</ol>
<p><strong>CAUTION!</strong> Never use steam cleaners; allow oven to cool completely before cleaning.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Cool-touch door: Double glazing keeps exterior cool. Child Lock: Prevents accidental operation. Auto shut-off: Timer turns oven off after set time. Thermal safety cut-out: Prevents overheating.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Regulatory Information</h2>
<p>CE marked; complies with EU safety and EMC directives. Manufactured to EN 60335 standards. For UK, complies with Electrical Equipment (Safety) Regulations. Disposal: Follow WEEE regulations; do not dispose with household waste. For support, visit www.beko.co.uk or contact 0333 207 9710.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Oven not heating</td><td>Power supply/timer</td><td>Check power connection; ensure timer is set; verify function selector position.</td></tr>
<tr><td>Uneven cooking</td><td>Rack position/temperature</td><td>Adjust rack to correct height; preheat oven; use fan function for even heat.</td></tr>
<tr><td>Door not closing</td><td>Obstruction/hinge</td><td>Check for food debris; ensure hinges are clean and undamaged.</td></tr>
<tr><td>Timer not working</td><td>Settings/power</td><td>Reset clock; check power supply; reprogram timer.</td></tr>
<tr><td>Light not working</td><td>Bulb</td><td>Replace bulb (type: E14, 25W). Disconnect power first.</td></tr>
</table>
<p><strong>Reset:</strong> Disconnect power for 5 minutes, then reconnect.</p>
<p><strong>Service:</strong> 0333 207 9710; www.beko.co.uk</p>
<div style="text-align: center;">
Beko Double Oven KDC653W Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
