<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Electric Cooker Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Electric Cooker Manual</h1>
<p>The Beko Electric Cooker is a versatile and energy-efficient kitchen appliance designed for modern cooking needs. It features multiple cooking zones, precise temperature control, safety mechanisms, and easy-to-clean surfaces. Below are key sections covering safety, features, installation, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Cooking Functions</a>
<a href="#section8">7. Safety Features</a>
<a href="#section9">8. Care & Cleaning</a>
<a href="#section10">9. Regulatory Information</a>
<a href="#section11">10. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Ceramic glass cooking surface, Heating zones, Control panel, Power cord, Residual heat indicators.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Ceramic Glass Surface</td><td>Smooth, easy-to-clean surface with high heat resistance</td></tr>
<tr><td>Heating Zones</td><td>Multiple zones with individual temperature controls</td></tr>
<tr><td>Control Panel</td><td>Touch controls with digital display for precise settings</td></tr>
<tr><td>Residual Heat Indicators</td><td>LED lights show when zones are still hot after use</td></tr>
<tr><td>Timer Function</td><td>Built-in timer for automatic shut-off</td></tr>
<tr><td>Child Lock</td><td>Safety feature to prevent accidental activation</td></tr>
<tr><td>Power Boost</td><td>Rapid heating function for faster cooking</td></tr>
<tr><td>Pan Detection</td><td>Automatically detects cookware and adjusts heating</td></tr>
<tr><td>Overheat Protection</td><td>Safety cut-off to prevent damage from excessive heat</td></tr>
<tr><td>Energy Saving Mode</td><td>Reduces power consumption during standby</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure proper ventilation and electrical connection.</p>
<ol>
<li>Choose location: Place on stable, heat-resistant surface away from water sources.</li>
<li>Electrical connection: Connect to dedicated 220-240V AC outlet with proper grounding.</li>
<li>Ventilation: Maintain minimum 10cm clearance around sides and back.</li>
<li>Initial test: Power on to verify all indicators and controls function properly.</li>
</ol>
<p><strong>WARNING!</strong> Installation must be performed by qualified personnel. Ensure proper electrical rating and grounding.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Power on cooker; follow initial setup procedure.</p>
<ol>
<li>Language selection: Press SETTINGS button to select preferred language.</li>
<li>Clock setting: Set current time using +/- buttons.</li>
<li>Unit preference: Choose between Celsius or Fahrenheit temperature display.</li>
<li>Test heating zones: Activate each zone briefly to ensure proper function.</li>
<li>Child lock: Enable if needed by holding LOCK button for 3 seconds.</li>
</ol>
<p><strong>CAUTION!</strong> Do not place any objects on cooking surface during first use. Allow initial heating cycle to complete.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko Electric Cooker Series</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50-60Hz</li>
<li><strong>Power Consumption:</strong> 2000-3000W (maximum)</li>
<li><strong>Cooking Zones:</strong> 4 heating zones with individual controls</li>
<li><strong>Temperature Range:</strong> 60°C to 240°C (140°F to 464°F)</li>
<li><strong>Dimensions:</strong> Standard 60cm width, 52cm depth, 6cm height</li>
<li><strong>Weight:</strong> Approximately 8kg</li>
<li><strong>Control Type:</strong> Touch-sensitive digital controls</li>
<li><strong>Safety Features:</strong> Child lock, overheat protection, residual heat indicators</li>
<li><strong>Warranty:</strong> 2 years standard warranty</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Access controls via touch panel. Main buttons: POWER, ZONE SELECT, TEMPERATURE +/-, TIMER, LOCK, BOOST.</p>
<p><strong>Control Panel:</strong> Digital display shows temperature, timer, and active zones. Touch zones to activate individual heating areas.</p>
<p>Temperature Settings: Adjust from 60°C to 240°C in 10°C increments. Timer Function: Set from 1 minute to 3 hours. Boost Function: Increases power to selected zone for 10 minutes. Lock Function: Press and hold LOCK for 3 seconds to enable/disable child safety. Settings Menu: Access language, units, and default preferences.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Cooking Functions</h2>
<p>Supports various cooking methods with precise temperature control.</p>
<ol>
<li>Select zone: Touch desired cooking zone icon on control panel.</li>
<li>Set temperature: Use +/- buttons to select cooking temperature.</li>
<li>Activate boost: Press BOOST for rapid heating when needed.</li>
<li>Set timer: Press TIMER and use +/- to set automatic shut-off time.</li>
<li>Multi-zone cooking: Activate up to 4 zones simultaneously with individual settings.</li>
<li>Keep warm function: Set to 70°C-80°C for keeping food warm.</li>
<li>Melt setting: Low temperature (60°C-80°C) for delicate melting tasks.</li>
<li>Simmer function: Maintain consistent low heat for slow cooking.</li>
</ol>
<p><strong>Tip:</strong> Use flat-bottomed cookware for optimal heat transfer and energy efficiency.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Safety Features</h2>
<p>Child Lock: Prevents accidental activation. Residual Heat Indicators: LED lights show hot zones. Overheat Protection: Automatic shut-off if temperature exceeds safe limits. Pan Detection: Only heats when suitable cookware is detected. Auto Shut-off: Turns off after 1 hour if no changes detected.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Care & Cleaning</h2>
<p>Unplug and cool completely before cleaning. Use recommended cleaners only.</p>
<ol>
<li>Daily cleaning: Wipe with damp cloth and mild detergent.</li>
<li>Stain removal: Use ceramic glass cleaner for stubborn stains.</li>
<li>Control panel: Clean with soft, dry cloth only.</li>
<li>Avoid: Abrasive cleaners, steel wool, or sharp objects.</li>
<li>Spill management: Clean immediately to prevent staining.</li>
</ol>
<p><strong>CAUTION!</strong> Never pour water directly on cooking surface. Do not use oven cleaners or abrasive materials.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Regulatory Information</h2>
<p>CE Certified: Complies with European safety standards. RoHS Compliant: Free from hazardous substances. Energy Class: Rated A for energy efficiency. Manufactured under ISO 9001 quality standards. Copyright © Beko plc. For support, visit www.beko.com or contact customer service at 1-800-555-BEKO.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Cooker not heating</td><td>Power supply/child lock</td><td>Check power connection; ensure child lock is disabled; verify circuit breaker.</td></tr>
<tr><td>Uneven heating</td><td>Cookware/surface</td><td>Use flat-bottomed pans; ensure cooking zone is clean; check for damage.</td></tr>
<tr><td>Error code displayed</td><td>System fault</td><td>Note error code; unplug for 5 minutes; plug back in; contact service if persists.</td></tr>
<tr><td>Control panel unresponsive</td><td>Moisture/lock</td><td>Dry surface completely; disable child lock; restart appliance.</td></tr>
<tr><td>Automatic shut-off</td><td>Overheat/timer</td><td>Allow to cool; check timer settings; ensure proper ventilation.</td></tr>
<tr><td>Residual lights stay on</td><td>Normal operation</td><td>Indicates surface is hot; wait for lights to turn off before cleaning.</td></tr>
<tr><td>Boost function not working</td><td>Temperature limit</td><td>Boost only works below maximum temperature; reduce setting then activate.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 10 minutes to reset electronic controls.</p>
<p><strong>Service:</strong> 1-800-555-BEKO; www.beko.com/support</p>
<div style="text-align: center;">
Beko Electric Cooker Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
