<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Gas Cooker Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Gas Cooker Manual</h1>
<p>The Beko Gas Cooker is a reliable and efficient kitchen appliance designed for safe and convenient cooking. It features multiple gas burners with precise flame control, an electric ignition system, durable enamel-coated grates, a built-in oven with thermostat control, safety features including flame failure devices, and easy-to-clean surfaces. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Gas Supply</a>
<a href="#section8">7. Operating the Cooker</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Gas burners with control knobs, Electric ignition button, Oven with thermostat, Enamel-coated grates and burner caps, Flame failure safety device, Oven door with heat-resistant glass.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Gas Burners</td><td>Multiple burners with adjustable flame control for different cooking needs</td></tr>
<tr><td>Electric Ignition</td><td>Push-button ignition for easy and safe burner lighting</td></tr>
<tr><td>Oven Thermostat</td><td>Precise temperature control for baking and roasting</td></tr>
<tr><td>Flame Failure Device</td><td>Automatically cuts off gas supply if flame goes out</td></tr>
<tr><td>Enamel Coating</td><td>Durable and easy-to-clean surfaces on grates and burner caps</td></tr>
<tr><td>Control Knobs</td><td>Clearly marked for burner control and oven settings</td></tr>
<tr><td>Oven Light</td><td>Interior light for monitoring cooking progress</td></tr>
<tr><td>Door Lock</td><td>Safety lock to prevent accidental opening during use</td></tr>
<tr><td>Gas Supply Connection</td><td>Standard connection point for natural gas or LPG</td></tr>
<tr><td>Adjustable Feet</td><td>For leveling the cooker on uneven surfaces</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure installation area is well-ventilated and away from flammable materials.</p>
<ol>
<li>Position the cooker: Place on a stable, level surface with adequate clearance from walls and cabinets.</li>
<li>Connect gas supply: Use approved flexible hose or rigid piping; ensure connection is secure and leak-free.</li>
<li>Check for leaks: Apply soap solution to connections; bubbles indicate leaks—tighten or repair immediately.</li>
<li>Adjust feet: Use adjustable feet to level the cooker if necessary.</li>
</ol>
<p><strong>WARNING!</strong> Installation must be performed by a qualified gas fitter in accordance with local regulations. Do not use if smell of gas is present.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, remove all packaging materials and protective films.</p>
<ol>
<li>Clean surfaces: Wipe cooker with damp cloth and mild detergent; dry thoroughly.</li>
<li>Test ignition: Press ignition button while turning a burner knob to ensure spark occurs.</li>
<li>Burn in oven: Heat oven at maximum temperature for 30 minutes to remove manufacturing residues.</li>
<li>Familiarize controls: Review control knobs and settings for burners and oven.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure adequate ventilation during initial use. Keep children away from the appliance.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model Type:</strong> Beko Gas Cooker (multiple models available).</li>
<li><strong>Burners:</strong> 4 or 5 burners (depending on model) with different heat outputs.</li>
<li><strong>Ignition:</strong> Electric push-button ignition (battery or mains powered).</li>
<li><strong>Oven Capacity:</strong> Varies by model (typically 50-70 liters).</li>
<li><strong>Oven Functions:</strong> Thermostat-controlled heating, grill function (on select models).</li>
<li><strong>Gas Type:</strong> Natural gas or LPG (check model label for correct type).</li>
<li><strong>Dimensions:</strong> Standard width 50-60 cm; check specific model manual.</li>
<li><strong>Materials:</strong> Enamel-coated steel, heat-resistant glass, stainless steel accents.</li>
<li><strong>Power Supply:</strong> For ignition: 1.5V battery (type AA) or 220-240V AC.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: Burner knobs (marked with symbols), Oven thermostat knob, Ignition button, Oven function selector (if applicable).</p>
<p><strong>Burner Knobs:</strong> Turn to control flame size (from off to high). <strong>Ignition:</strong> Press while turning burner knob to light. <strong>Oven Thermostat:</strong> Set desired temperature (typically 50-250°C). <strong>Oven Function Selector:</strong> Choose between oven heating, grill, or fan (if available).</p>
<p>Safety: Flame failure device automatically cuts gas if flame extinguishes. Always turn knobs to off position after use.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Gas Supply</h2>
<p>Only connect to approved gas type (natural gas or LPG as per model).</p>
<ol>
<li>Ensure cooker is off and gas supply valve is closed.</li>
<li>Connect flexible hose or rigid pipe to cooker inlet and gas supply point.</li>
<li>Use appropriate sealant (e.g., PTFE tape) on threaded connections.</li>
<li>Open gas supply valve and check for leaks with soap solution.</li>
<li>Test ignition and burner operation.</li>
</ol>
<p><strong>Tip:</strong> If converting between gas types, use official conversion kit and have it installed by a professional.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Operating the Cooker</h2>
<p>For daily cooking operations.</p>
<ol>
<li>Lighting burners: Press ignition button while turning burner knob to flame symbol; hold for few seconds after ignition.</li>
<li>Adjusting flame: Turn knob to desired position (small flame for simmering, large for boiling).</li>
<li>Using oven: Set thermostat to desired temperature; preheat for 10-15 minutes before use.</li>
<li>Grill function: Turn function selector to grill; use oven door slightly open if specified.</li>
<li>Turning off: Turn burner knob fully to off position; for oven, turn thermostat to off.</li>
</ol>
<p><strong>WARNING!</strong> Never leave cooker unattended while in use. Keep flammable materials away from burners.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Flame Failure Device: Cuts gas supply if flame is extinguished (e.g., by drafts or spills). Thermocouple Safety: Prevents gas flow if ignition fails. Oven Door Lock: Locks during high-temperature cleaning cycles (on some models). Child Lock: Prevents accidental operation of controls (if equipped).</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Allow cooker to cool completely before cleaning. Use mild detergent and soft cloth; avoid abrasive cleaners.</p>
<p><strong>Daily:</strong> Wipe spills immediately with damp cloth. <strong>Burner caps and grates:</strong> Remove and wash in warm soapy water; dry thoroughly before replacing. <strong>Oven interior:</strong> Use oven cleaner for stubborn stains; follow product instructions. <strong>Glass door:</strong> Clean with glass cleaner; avoid scratching.</p>
<p><strong>CAUTION!</strong> Do not use steam cleaners or high-pressure jets. Never immerse control panel or knobs in water.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>Complies with relevant gas appliance safety standards (e.g., EN 30-1-1). CE marked for European market. Manufactured under quality management system ISO 9001. For support, visit www.beko.com or contact local Beko service center. Keep this manual for future reference.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Burner won't light</td><td>No gas/ignition issue</td><td>Check gas supply; replace ignition battery; ensure knob is pressed while igniting.</td></tr>
<tr><td>Flame is yellow or uneven</td><td>Burner clogged</td><td>Clean burner ports with soft brush; ensure proper gas pressure.</td></tr>
<tr><td>Oven not heating</td><td>Thermostat setting/gas supply</td><td>Check thermostat is set correctly; verify gas supply to oven burner.</td></tr>
<tr><td>Gas smell</td><td>Leak in connection</td><td>Turn off gas immediately; ventilate area; check connections with soap solution.</td></tr>
<tr><td>Ignition spark not occurring</td><td>Battery dead or electrode dirty</td><td>Replace battery; clean ignition electrode with dry cloth.</td></tr>
</table>
<p><strong>Service:</strong> If problem persists, contact authorized Beko service technician. Do not attempt repairs yourself.</p>
<p><strong>Contact:</strong> Beko customer support: www.beko.com or local service number.</p>
<div style="text-align: center;">
Beko Gas Cooker Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
