<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko KDC653W User Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko KDC653W User Manual</h1>
<p>The Beko KDC653W is a 65cm undercounter fridge freezer with a total net capacity of 53 litres (fridge) and 15 litres (freezer), featuring a 1-star freezer compartment suitable for storing pre-frozen food and making ice cubes. It operates on a mains voltage of 220-240V and 50Hz frequency. Below are key sections covering safety instructions, product features, installation, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Using Your Appliance</a>
<a href="#section8">7. Maintenance & Cleaning</a>
<a href="#section9">8. Energy Saving Tips</a>
<a href="#section10">9. Regulatory Information</a>
<a href="#section11">10. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Undercounter design, 1-star freezer compartment, adjustable thermostat, reversible door, interior light, adjustable feet, and removable glass shelves.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Capacity</td><td>53 litres fridge, 15 litres freezer (1-star)</td></tr>
<tr><td>Energy Class</td><td>As per energy label provided</td></tr>
<tr><td>Thermostat</td><td>Adjustable temperature control dial</td></tr>
<tr><td>Door</td><td>Reversible for left or right opening</td></tr>
<tr><td>Interior Light</td><td>Illuminates interior when door is open</td></tr>
<tr><td>Shelves</td><td>Removable tempered glass shelves</td></tr>
<tr><td>Crisper</td><td>Salad drawer to maintain humidity</td></tr>
<tr><td>Freezer Compartment</td><td>1-star rating for storing frozen food up to -6°C</td></tr>
<tr><td>Adjustable Feet</td><td>For levelling the appliance</td></tr>
<tr><td>Power Supply</td><td>220-240V, 50Hz</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure all packaging materials are removed.</p>
<ol>
<li>Choose location: Install on a flat, stable, and well-ventilated surface away from heat sources.</li>
<li>Adjust feet: Use a spanner to adjust the feet until the appliance is level.</li>
<li>Set door direction: Reverse door if necessary using instructions in manual.</li>
<li>Clearance: Allow at least 5cm clearance at rear and sides for ventilation.</li>
<li>Electrical connection: Plug into a grounded 220-240V, 50Hz socket. Do not use an extension cord.</li>
</ol>
<p><strong>WARNING!</strong> Do not install near ovens, radiators, or in direct sunlight. Ensure the plug is accessible after installation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, clean the interior with warm water and mild detergent. Dry thoroughly.</p>
<ol>
<li>Position: Place appliance in its final location and level it.</li>
<li>Standby time: Leave the appliance plugged in and switched on for 2-4 hours before placing food inside to allow temperature to stabilise.</li>
<li>Thermostat setting: Set thermostat dial to mid position (e.g., setting 3 or 4).</li>
<li>Loading: Place food items, ensuring air can circulate around them.</li>
</ol>
<p><strong>CAUTION!</strong> Do not load appliance immediately after switching on. Allow it to reach correct temperature.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko KDC653W</li>
<li><strong>Type:</strong> Undercounter Fridge Freezer</li>
<li><strong>Total Net Capacity:</strong> 68 litres (53L fridge + 15L freezer)</li>
<li><strong>Freezer Star Rating:</strong> 1-star (suitable for storing pre-frozen food up to 1 week)</li>
<li><strong>Energy Consumption:</strong> Refer to energy label</li>
<li><strong>Climate Class:</strong> N (SN, ST, T) – suitable for ambient temperatures 16°C to 43°C</li>
<li><strong>Refrigerant:</strong> R600a</li>
<li><strong>Noise Level:</strong> ≤40 dB(A)</li>
<li><strong>Power Supply:</strong> 220-240V, 50Hz</li>
<li><strong>Dimensions (HxWxD):</strong> Approximately 85cm x 55cm x 60cm</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>The main control is the thermostat dial located inside the fridge compartment.</p>
<p><strong>Thermostat Dial:</strong> Rotate clockwise to increase cooling (higher number = colder). Rotate anti-clockwise to decrease cooling (lower number = warmer). Setting 0 or OFF turns the compressor off.</p>
<p><strong>Recommended Settings:</strong> For normal use, set between 3 and 4. Adjust according to ambient temperature and load.</p>
<p><strong>Freezer Compartment:</strong> Temperature is controlled by the same thermostat. Ensure freezer door is closed properly.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Using Your Appliance</h2>
<p>Fridge compartment: Store fresh food, dairy, drinks, and vegetables. Freezer compartment: Store pre-frozen food, ice cubes.</p>
<ol>
<li>Organise food: Place items with space between for air circulation.</li>
<li>Crisper drawer: Use for fruits and vegetables to retain moisture.</li>
<li>Freezer use: Do not store fresh food to be frozen for long periods (1-star rating).</li>
<li>Door storage: Use door shelves for bottles, jars, and condiments.</li>
<li>Defrosting: Fridge defrosts automatically. Freezer may require manual defrosting if ice build-up exceeds 5mm.</li>
</ol>
<p><strong>Tip:</strong> Allow hot food to cool to room temperature before placing in appliance to save energy.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Maintenance & Cleaning</h2>
<p>Unplug appliance before cleaning.</p>
<ol>
<li>Interior: Clean with warm water and mild detergent. Do not use abrasive cleaners.</li>
<li>Shelves and drawers: Remove and wash separately. Dry thoroughly before replacing.</li>
<li>Exterior: Wipe with a damp cloth. For stainless steel models, use appropriate cleaner.</li>
<li>Door seals: Clean gently with soapy water to maintain seal efficiency.</li>
<li>Condensation outlet: Ensure it is not blocked (if applicable).</li>
</ol>
<p><strong>CAUTION!</strong> Never use sharp objects to remove ice. Do not pour water inside the appliance.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Energy Saving Tips</h2>
<ul>
<li>Set thermostat to recommended setting (3-4).</li>
<li>Ensure door seals are clean and intact.</li>
<li>Allow hot food to cool before storing.</li>
<li>Do not leave door open longer than necessary.</li>
<li>Ensure adequate ventilation around appliance.</li>
<li>Defrost freezer regularly if manual defrost.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Regulatory Information</h2>
<p>This appliance complies with relevant EU Directives and UK regulations. It contains refrigerant R600a (flammable) and insulation blowing gas (cyclopentane). Dispose of according to local regulations at end of life. For service, contact authorised Beko service agents. Manufacturer: Beko PLC. For support, visit www.beko.co.uk or contact customer service.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Appliance not working</td><td>No power</td><td>Check plug is switched on and socket is live. Check fuse.</td></tr>
<tr><td>Temperature too warm</td><td>Thermostat setting, door seal, ventilation</td><td>Adjust thermostat to colder setting. Check door seal. Ensure ventilation gaps are clear.</td></tr>
<tr><td>Excessive frost in freezer</td><td>Door left open, frequent opening</td><td>Defrost manually. Ensure door closes properly. Minimise door openings.</td></tr>
<tr><td>Unusual noise</td><td>Appliance not level, items touching rear</td><td>Level the appliance. Ensure bottles/food are not touching interior walls.</td></tr>
<tr><td>Water inside or under appliance</td><td>Blocked defrost water outlet, spillage</td><td>Check and clear outlet tube (if accessible). Clean spilled liquids.</td></tr>
<tr><td>Light not working</td><td>Bulb failure</td><td>Replace bulb with same type (max 15W). Unplug appliance first.</td></tr>
</table>
<p><strong>Reset:</strong> Turn thermostat to OFF, wait 5 minutes, then turn back on.</p>
<p><strong>Service:</strong> For persistent issues, contact Beko customer service. Do not attempt repairs yourself.</p>
<div style="text-align: center;">
Beko KDC653W User Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
