<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko KS530W Cooker Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko KS530W Cooker Manual</h1>
<p>The Beko KS530W is a freestanding electric cooker featuring a 60cm width, 4 electric hotplates, a multifunction electric oven with fan, grill, and conventional heating modes, a programmable timer, a glass door with triple glazing, and a catalytic enamel back panel for easier cleaning. It operates on a standard 220-240V AC power supply. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Using the Hob</a>
<a href="#section8">7. Using the Oven</a>
<a href="#section9">8. Cleaning & Maintenance</a>
<a href="#section10">9. Safety Features</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Electric Hob with 4 heating zones, Multifunction Electric Oven, Electronic Timer, Control Panel, Oven Door with Triple Glazing, Catalytic Liner.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Hob</td><td>4 electric hotplates (various sizes) with residual heat indicators</td></tr>
<tr><td>Oven</td><td>Multifunction with fan, conventional, grill, and defrost modes</td></tr>
<tr><td>Timer</td><td>Programmable electronic timer with automatic cooking functions</td></tr>
<tr><td>Door</td><td>Triple-glazed glass door for heat retention and safety</td></tr>
<tr><td>Interior</td><td>Enamel coating and catalytic back panel for easier cleaning</td></tr>
<tr><td>Power Indicator</td><td>Lights show when a hob plate or the oven is active</td></tr>
<tr><td>Control Knobs</td><td>For selecting oven functions, temperature, and hob heat levels</td></tr>
<tr><td>Oven Light</td><td>Illuminates the oven cavity for visibility</td></tr>
<tr><td>Safety Thermostat</td><td>Prevents overheating</td></tr>
<tr><td>Dimensions</td><td>60cm width, standard freestanding height and depth</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure the installation location is level, stable, and away from combustible materials.</p>
<ol>
<li>Positioning: Place the cooker in its final location, ensuring adequate ventilation space around it.</li>
<li>Electrical Connection: Must be performed by a qualified electrician. Connect to a dedicated circuit with correct fuse rating (refer to specifications).</li>
<li>Stability Check: Ensure all feet are adjusted so the cooker is level and does not rock.</li>
<li>Remove Protections: Take off any transit bolts, protective films, or packaging materials from the hob and oven interior.</li>
</ol>
<p><strong>WARNING!</strong> This appliance is heavy; use two people to move it. Do not lift by the door or control panel. Ensure the power supply is disconnected during installation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, clean the appliance and perform an initial heat cycle to burn off any manufacturing residues.</p>
<ol>
<li>Initial Cleaning: Wipe the hob, oven interior, and door with a damp cloth and mild detergent. Dry thoroughly.</li>
<li>First Oven Use: Set the oven to the maximum temperature (e.g., 250°C) using the conventional heating function. Run empty for 60 minutes with good ventilation.</li>
<li>Setting the Clock: Turn the timer knob to set the current time.</li>
<li>Hob Test: Briefly turn on each hotplate to ensure they heat up correctly.</li>
</ol>
<p><strong>CAUTION!</strong> Smoke or odor during the first heating is normal. Ensure the room is well-ventilated.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model:</strong> Beko KS530W</li>
<li><strong>Type:</strong> Freestanding Electric Cooker</li>
<li><strong>Width:</strong> 60 cm</li>
<li><strong>Hob:</strong> 4 Electric Hotplates (various diameters: e.g., 2 x 180mm, 1 x 145mm, 1 x 210mm)</li>
<li><strong>Oven Capacity:</strong> Approx. 60 Litres</li>
<li><strong>Oven Functions:</strong> Fan, Conventional, Grill, Fan Grill, Defrost, Bottom Heat</li>
<li><strong>Energy Class:</strong> Refer to energy label (A or higher for most models)</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50/60Hz</li>
<li><strong>Total Power:</strong> Approx. 9.5 kW (check rating plate)</li>
<li><strong>Control:</strong> Mechanical knobs and electronic timer</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: Located at the front of the cooker. Hob Controls: Four individual knobs (0-6 or 0-9 settings) for each hotplate. Oven Controls: Two knobs for function selection and temperature setting (50-250°C). Timer Knob: For setting cooking duration and automatic start/stop.</p>
<p><strong>Oven Functions:</strong>
- **Fan Symbol:** For even, faster cooking at lower temperatures.
- **Conventional Symbol:** Top and bottom heating elements.
- **Grill Symbol:** Top heating element for grilling.
- **Fan Grill Symbol:** Grill with fan for more even browning.
- **Defrost Symbol:** Fan operates without heat to defrost food.
- **Bottom Heat Symbol:** For baking pizzas or finishing dishes with a crisp base.</p>
<p><strong>Timer Use:</strong> Turn to set cooking duration. The oven will switch off automatically when time elapses. A bell will sound.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Using the Hob</h2>
<p>Select the appropriate hotplate size for your pan. The pan base should match the hotplate diameter.</p>
<ol>
<li>Turn the corresponding knob to the desired heat level (1=Low, 6 or 9=High).</li>
<li>The power indicator light for that zone will illuminate.</li>
<li>Use flat-bottomed pans for best contact and energy efficiency.</li>
<li>You can use the residual heat after switching off. The 'H' indicator will remain lit until the plate cools.</li>
<li>To switch off, turn the knob to the '0' position.</li>
</ol>
<p><strong>Tip:</strong> For energy saving, bring liquids to a boil on a high setting, then reduce to a simmer.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using the Oven</h2>
<p>Supports baking, roasting, grilling, and defrosting.</p>
<ol>
<li>Preheating: Select the desired function and temperature. Allow 10-15 minutes for the oven to reach temperature.</li>
<li>Placing Food: Use the provided wire shelves and baking tray. For best air circulation, do not cover oven racks with foil.</li>
<li>Grilling: Use the grill function. Place food on the wire shelf in the upper or middle position. Keep the oven door slightly ajar (if specified in manual) during grilling.</li>
<li>Using the Timer: Set the desired cooking duration. The oven will beep and switch off automatically.</li>
<li>Changing Settings: You can change the function or temperature during cooking.</li>
<li>After Cooking: Turn both oven knobs to '0'. The oven light and fan may run for a cooling period.</li>
</ol>
<p><strong>WARNING!</strong> The oven and door become very hot. Use oven gloves. Do not place flammable materials on or near the cooker.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Cleaning & Maintenance</h2>
<p>Always disconnect from power before cleaning. Allow to cool completely.</p>
<p><strong>Hob:</strong> Wipe with a damp cloth and mild cleaner when cool. Remove spills promptly. Do not use abrasive pads or harsh chemicals.</p>
<p><strong>Oven Interior:</strong> The catalytic back panel helps break down fat splashes. Clean other surfaces with a damp cloth. For heavy soiling, use a dedicated oven cleaner (non-caustic) following product instructions.</p>
<p><strong>Door:</strong> Clean glass with a glass cleaner. The inner glass pane can be removed for cleaning (refer to manual for removal instructions).</p>
<p><strong>Control Panel/Knobs:</strong> Wipe with a damp cloth. Do not immerse knobs in water.</p>
<p><strong>CAUTION!</strong> Never use steam cleaners. Do not spray water or cleaner directly onto control panel or electrical parts.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Safety Features</h2>
<p>Residual Heat Indicators (Hob): Show which plates are still hot after switching off. Safety Thermostat (Oven): Cuts power if oven overheats. Cool-Touch Door (where fitted): Triple glazing reduces external door temperature. Child Lock (if applicable): Locks control panel to prevent accidental operation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>This appliance complies with relevant EU Directives and UK safety standards. The symbol of the crossed-out wheeled bin indicates that this product must be disposed of separately from household waste at its end of life. Refer to local regulations for disposal. For support, visit www.beko.co.uk or contact the Beko helpline.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Hob plate does not heat</td><td>Knob not set / Faulty connection</td><td>Ensure knob is turned to a heat setting. Check if other plates work. If not, check circuit breaker/fuse.</td></tr>
<tr><td>Oven does not heat</td><td>Function/Temp not set / Timer active</td><td>Ensure both function and temperature knobs are correctly set. Check timer is not in 'auto' mode preventing start.</td></tr>
<tr><td>Oven light not working</td><td>Bulb burnt out</td><td>Replace oven light bulb (type specified in manual). Disconnect power first.</td></tr>
<tr><td>Uneven cooking</td><td>Incorrect shelf position / No preheat</td><td>Use recommended shelf positions for the function. Always preheat the oven.</td></tr>
<tr><td>Timer bell does not sound</td><td>Timer not set correctly / Fault</td><td>Re-check timer setting procedure. Manual override may be required.</td></tr>
<tr><td>Error Code Displayed (if applicable)</td><td>Electronic fault</td><td>Disconnect power for 5 minutes, then reconnect. If code persists, contact service.</td></tr>
</table>
<p><strong>Reset:</strong> Disconnect from mains power for 5 minutes to reset electronic controls.</p>
<p><strong>Service:</strong> For electrical or mechanical faults, contact an authorized Beko service agent. Do not attempt repairs yourself.</p>
<div style="text-align: center;">
Beko KS530W Cooker Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
