<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Oven User Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Oven User Manual</h1>
<p>The Beko Oven is a modern electric oven featuring multiple cooking functions, digital controls, safety features, and energy-efficient operation. This manual covers essential information for safe installation, operation, maintenance, and troubleshooting of your Beko oven. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Cooking Functions</a>
<a href="#section8">7. Cleaning & Maintenance</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Regulatory Information</a>
<a href="#section11">10. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Digital control panel, oven cavity, heating elements, fan, door with glass, interior light, and removable racks.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Digital Control Panel</td><td>Touch controls for temperature, timer, and cooking functions</td></tr>
<tr><td>Multiple Cooking Functions</td><td>Conventional, fan, grill, defrost, and combination modes</td></tr>
<tr><td>Interior Light</td><td>Illuminates oven interior for monitoring cooking progress</td></tr>
<tr><td>Removable Racks</td><td>Adjustable and removable for flexible cooking arrangements</td></tr>
<tr><td>Safety Door Lock</td><td>Automatic lock during certain cooking functions</td></tr>
<tr><td>Cool-Touch Door</td><td>Double-glazed glass door remains cool during operation</td></tr>
<tr><td>Timer with Alarm</td><td>Programmable countdown timer with audible alert</td></tr>
<tr><td>Energy Efficiency</td><td>A-rated for reduced power consumption</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental operation by children</td></tr>
<tr><td>Self-Cleaning Function</td><td>Pyrolytic cleaning option available on select models</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Ensure proper electrical connection and ventilation.</p>
<ol>
<li>Choose location: Install in well-ventilated area away from flammable materials.</li>
<li>Electrical connection: Connect to dedicated 220-240V AC, 50Hz circuit with proper grounding.</li>
<li>Secure installation: Mount securely in cabinet or on stand according to dimensions.</li>
<li>Initial check: Verify door seals properly and all controls are accessible.</li>
</ol>
<p><strong>WARNING!</strong> Installation must be performed by qualified technician. Ensure power is disconnected during installation.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first use, prepare the oven for cooking.</p>
<ol>
<li>Remove packaging: Remove all protective films and packaging materials.</li>
<li>Initial cleaning: Wipe interior with damp cloth and mild detergent.</li>
<li>Burn-off cycle: Run oven empty at 200°C for 30 minutes to remove manufacturing residues.</li>
<li>Set clock: Program digital clock using control panel.</li>
<li>Test functions: Verify all cooking modes and temperature settings work properly.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure proper ventilation during burn-off cycle. Keep area clear of flammable materials.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Capacity:</strong> 60-70 liters (varies by model).</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50Hz.</li>
<li><strong>Power Consumption:</strong> 2000-3000W.</li>
<li><strong>Cooking Functions:</strong> Conventional, fan, grill, defrost, pizza, bread baking.</li>
<li><strong>Temperature Range:</strong> 50°C to 250°C.</li>
<li><strong>Timer:</strong> 1 minute to 120 minutes with alarm.</li>
<li><strong>Dimensions:</strong> Standard 60cm width (check specific model).</li>
<li><strong>Energy Rating:</strong> A or higher for energy efficiency.</li>
<li><strong>Warranty:</strong> 2 years standard warranty.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: Temperature dial/buttons, function selector, timer controls, start/stop button.</p>
<p><strong>Basic Operations:</strong> Select cooking function, set temperature, set timer, press start.</p>
<p>Cooking Functions: Conventional (top and bottom heat), Fan (circulated hot air), Grill (top heating element), Defrost (gentle fan without heat), Combination (fan + grill). Temperature Settings: Adjustable in 5°C increments. Timer: Countdown with audible alarm. Child Lock: Press and hold lock button for 3 seconds. Clock Setting: Adjust using +/- buttons while in clock mode.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Cooking Functions</h2>
<p>Optimize cooking results using appropriate functions.</p>
<ol>
<li>Conventional Baking: For cakes, pastries, and baked goods requiring even heat.</li>
<li>Fan Cooking: For faster, more even cooking of multiple dishes simultaneously.</li>
<li>Grilling: For browning, toasting, and cooking meats quickly.</li>
<li>Defrosting: For thawing frozen foods safely.</li>
<li>Pizza Function: Special setting for crispy pizza bases.</li>
<li>Bread Baking: Optimized for homemade bread with crust control.</li>
</ol>
<p><strong>Tip:</strong> Preheat oven for 10-15 minutes before cooking for best results.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Cleaning & Maintenance</h2>
<p>Regular cleaning ensures optimal performance and longevity.</p>
<ol>
<li>Daily cleaning: Wipe exterior with damp cloth after cooling.</li>
<li>Interior cleaning: Remove racks and clean with mild detergent (avoid abrasive cleaners).</li>
<li>Door cleaning: Clean glass with glass cleaner; avoid getting liquid on seals.</li>
<li>Rack cleaning: Soak in warm soapy water; dry thoroughly before replacing.</li>
<li>Self-cleaning: Run pyrolytic cycle if available (empty oven, follow instructions).</li>
</ol>
<p><strong>CAUTION!</strong> Always disconnect power before cleaning. Never use steam cleaners or pressure washers.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Cool-Touch Door: Double glazing keeps exterior cool during operation. Child Lock: Prevents accidental operation. Safety Cut-Off: Automatically turns off if overheating detected. Door Lock: Locks during self-cleaning cycle. Residual Heat Indicator: Shows when surfaces are still hot after turning off.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Regulatory Information</h2>
<p>CE Certified: Complies with European safety standards. RoHS Compliant: Free from hazardous substances. Energy Label: Displays energy efficiency rating. For support, visit www.beko.com or contact local service center. Serial number located on rating plate inside door frame or rear panel.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Oven not heating</td><td>Power supply/function selection</td><td>Check power connection; ensure correct function selected; verify temperature setting.</td></tr>
<tr><td>Uneven cooking</td><td>Rack position/function selection</td><td>Adjust rack position; use fan function for even cooking; preheat properly.</td></tr>
<tr><td>Door not closing properly</td><td>Obstructions/worn seals</td><td>Check for obstructions; clean seals; replace if damaged.</td></tr>
<tr><td>Display not working</td><td>Power/child lock</td><td>Check power supply; disable child lock; reset circuit breaker.</td></tr>
<tr><td>Unusual noises</td><td>Fan obstruction/expansion noises</td><td>Check for foreign objects; some expansion noise is normal during heating.</td></tr>
<tr><td>Error codes on display</td><td>System faults</td><td>Note error code; disconnect power for 5 minutes; reconnect; if persists, contact service.</td></tr>
</table>
<p><strong>Reset:</strong> Disconnect from power for 5 minutes to reset electronic controls.</p>
<p><strong>Service:</strong> Contact authorized Beko service center. Have model and serial numbers ready.</p>
<div style="text-align: center;">
Beko Oven User Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
