<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko ProSmart Inverter Washing Machine Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko ProSmart Inverter Washing Machine Manual</h1>
<p>The Beko ProSmart Inverter Washing Machine is a front-loading laundry appliance featuring ProSmart Inverter Motor technology for energy efficiency and quiet operation, multiple wash programs (Cotton, Synthetic, Delicate, Quick Wash, etc.), load capacity of 8-10 kg, spin speeds up to 1400 RPM, delay timer, child lock, anti-crease function, and self-cleaning system. It includes features like Auto Dose detergent dispensing, SteamCare, and AllergyPlus programs. Below are key sections for safety, features, installation, setup, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water & Drain</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Special Functions</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: ProSmart Inverter Motor, LED Display, Control Dial, Auto Dose Detergent Dispenser, Door Lock, Water Inlet Valves, Drain Pump Filter.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>ProSmart Inverter Motor</td><td>Energy-efficient, quiet, and durable direct drive motor</td></tr>
<tr><td>Auto Dose</td><td>Automatically dispenses detergent and softener based on load</td></tr>
<tr><td>SteamCare</td><td>Steam function for hygiene and reduced wrinkles</td></tr>
<tr><td>AllergyPlus</td><td>Special program to remove allergens with extra rinses</td></tr>
<tr><td>Quick Wash</td><td>30-minute program for lightly soiled loads</td></tr>
<tr><td>Delay Timer</td><td>Delay start up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Locks controls to prevent accidental changes</td></tr>
<tr><td>Anti-Crease</td><td>Reduces wrinkles by tumbling periodically after wash</td></tr>
<tr><td>Self-Cleaning</td><td>Cleans drum and tub to prevent odor buildup</td></tr>
<tr><td>Spin Speed Control</td><td>Adjustable spin speed up to 1400 RPM</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on level, solid floor.</p>
<ol>
<li>Remove transit bolts: Use spanner to remove bolts at rear; keep for future moves.</li>
<li>Connect water supply: Attach inlet hoses to hot/cold taps (if applicable) and machine.</li>
<li>Connect drain hose: Place in standpipe or sink; ensure no kinks.</li>
<li>Level the machine: Adjust feet to prevent vibration; use spirit level.</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in wet areas. Ensure water connections are tight to prevent leaks.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Power on machine; perform initial setup.</p>
<ol>
<li>Run calibration: Select "Drum Clean" or "Initial Setup" program to calibrate sensors.</li>
<li>Set detergent in Auto Dose: Fill detergent and softener compartments; set dosage level.</li>
<li>Select language: Use Settings menu to choose display language (default ENGLISH).</li>
<li>Test run: Run a quick wash without laundry to check operation.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure transit bolts are removed before first use to avoid damage.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Capacity:</strong> 8-10 kg (varies by model).</li>
<li><strong>Motor:</strong> ProSmart Inverter Motor.</li>
<li><strong>Spin Speed:</strong> Up to 1400 RPM.</li>
<li><strong>Programs:</strong> Cotton, Synthetic, Delicate, Wool, Quick Wash, SteamCare, AllergyPlus, Drum Clean.</li>
<li><strong>Energy Rating:</strong> A+++ (most models).</li>
<li><strong>Water Supply:</strong> Cold fill (some models hot/cold).</li>
<li><strong>Dimensions:</strong> Standard front-loader size (approx. 85cm H x 60cm W x 60cm D).</li>
<li><strong>Power:</strong> 220-240V AC, 50Hz.</li>
<li><strong>Noise Level:</strong> ≤ 50 dB (wash), ≤ 70 dB (spin).</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Access via control dial and touch buttons. Display shows time, cycle stage, and options.</p>
<p><strong>Control Dial:</strong> Turn to select program (Cotton, Synthetic, etc.).</p>
<p><strong>Buttons:</strong> Start/Pause, Delay, Spin Speed, Temperature, Steam, Extra Rinse, Child Lock.</p>
<p>Settings: Temperature (cold to 90°C), Spin Speed (0-1400 RPM), Delay (1-24h), Pre-Wash, Extra Rinse. Auto Dose: Set dosage level (Low/Med/High). Special Modes: SteamCare, AllergyPlus, Quick Wash. Maintenance: Drum Clean program, Self-Cleaning reminder.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water & Drain</h2>
<p>Water Inlet: Connect hoses to taps and machine (red-hot, blue-cold if applicable). Drain: Place hose in standpipe (max height 1m).</p>
<ol>
<li>Turn off taps before connecting hoses.</li>
<li>Use only provided hoses; replace if damaged.</li>
<li>Ensure drain hose is secured to prevent slipping.</li>
<li>Check for leaks after connections.</li>
</ol>
<p><strong>Tip:</strong> Install a drip tray if machine is on wooden floor.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Supports various fabrics and soil levels.</p>
<ol>
<li>Load laundry: Open door, load evenly; do not overload.</li>
<li>Add detergent: Use Auto Dose or manual compartment.</li>
<li>Select program: Turn dial (e.g., Cotton for normal loads).</li>
<li>Adjust settings: Press Temp, Spin, etc., to customize.</li>
<li>Start: Press Start/Pause; door locks automatically.</li>
<li>Pause/change: Press Start/Pause to pause; wait for door unlock.</li>
<li>End of cycle: Signal sounds; door unlocks after short delay.</li>
<li>Remove laundry promptly to reduce wrinkles.</li>
</ol>
<p><strong>WARNING!</strong> Do not open door during high-temperature washes; steam may cause burns.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Special Functions</h2>
<p>SteamCare: Reduces allergens and wrinkles; select Steam button. AllergyPlus: Extra rinses for sensitive skin. Delay Timer: Set start time. Child Lock: Press and hold Child Lock for 3 seconds. Anti-Crease: Tumbles periodically after wash if enabled.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug before cleaning. Wipe exterior with damp cloth; clean detergent drawer monthly; run Drum Clean program every 30 cycles.</p>
<p><strong>CAUTION!</strong> Do not use abrasive cleaners; clean drain pump filter periodically to prevent blockages.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked; complies with EU directives for safety and EMC. Energy label according to EU regulations. Copyright © Beko plc; trademarks of Beko. For support, visit www.beko.com or contact local service center.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Power/door</td><td>Check plug; ensure door closed properly; press Start.</td></tr>
<tr><td>No water intake</td><td>Taps/hoses</td><td>Ensure taps on; check hoses for kinks; clean inlet filter.</td></tr>
<tr><td>Water doesn't drain</td><td>Drain hose/pump</td><td>Check hose for blockages; clean drain pump filter.</td></tr>
<tr><td>Excessive vibration</td><td>Leveling/load</td><td>Re-level machine; redistribute laundry; remove transit bolts.</td></tr>
<tr><td>Error code on display</td><td>Sensor/fault</td><td>Refer to manual error code list; reset by unplugging 5 min.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes; plug back in.</p>
<p><strong>Service:</strong> Contact authorized Beko service; www.beko.com.</p>
<div style="text-align: center;">
Beko ProSmart Inverter Washing Machine Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
