<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Washer Dryer User Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Washer Dryer User Manual</h1>
<p>The Beko Washer Dryer is a versatile laundry appliance combining washing and drying functions in one unit. It features multiple wash programs, energy-efficient drying cycles, child lock, delay start, and various fabric care options. Designed for household use, it operates on standard electrical and water connections. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Utilities</a>
<a href="#section8">7. Using Wash & Dry Programs</a>
<a href="#section9">8. Safety Features</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Control panel, detergent drawer, drum, filter, water inlet valves, drain hose, power cord.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Control Panel</td><td>Digital display with program selection buttons</td></tr>
<tr><td>Detergent Drawer</td><td>Compartments for detergent, softener, and pre-wash</td></tr>
<tr><td>Drum</td><td>Stainless steel drum for washing and drying</td></tr>
<tr><td>Filter</td><td>Accessible lint filter for maintenance</td></tr>
<tr><td>Water Inlet Valves</td><td>For hot and cold water connections</td></tr>
<tr><td>Drain Hose</td><td>For water drainage</td></tr>
<tr><td>Power Cord</td><td>For electrical connection</td></tr>
<tr><td>Door Lock</td><td>Safety lock during operation</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Delay Start</td><td>Allows delayed cycle start</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on level, stable floor.</p>
<ol>
<li>Connect water supply: Attach hot and cold water hoses to corresponding valves.</li>
<li>Connect drain hose: Place hose into standpipe or sink; secure to avoid slipping.</li>
<li>Level the machine: Adjust feet to ensure stability; use spirit level.</li>
<li>Plug into grounded electrical outlet.</li>
</ol>
<p><strong>WARNING!</strong> Machine is heavy; lift with care to avoid injury. Ensure all connections are secure and leak-free.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Power on machine; follow initial setup prompts.</p>
<ol>
<li>Run initial test cycle: Select quick wash without laundry to flush system.</li>
<li>Set language: Use settings menu to select preferred language (default ENGLISH).</li>
<li>Adjust default settings: Configure water hardness, temperature preferences.</li>
<li>Familiarize with programs: Review program guide for fabric types.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure machine is level; improper leveling can cause vibration and noise.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Capacity:</strong> 8 kg washing / 5 kg drying.</li>
<li><strong>Energy Rating:</strong> A++ for washing, B for drying.</li>
<li><strong>Programs:</strong> Cotton, Synthetic, Delicate, Quick Wash, Drying cycles.</li>
<li><strong>Spin Speed:</strong> Up to 1400 RPM.</li>
<li><strong>Water Connections:</strong> Hot & cold fill.</li>
<li><strong>Power Supply:</strong> 230V AC, 50Hz.</li>
<li><strong>Dimensions:</strong> Standard under-counter size.</li>
<li><strong>Noise Level:</strong> Below 70 dB during spin.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Access settings via control panel buttons and dial.</p>
<p><strong>Control Panel:</strong> POWER, Program dial, Start/Pause, Temperature, Spin speed, Delay start, Child lock.</p>
<p>Programs: COTTON, SYNTHETIC, DELICATE, QUICK WASH, DRYING. Settings: Temperature (cold to 90°C), Spin speed (400-1400 RPM), Extra rinse, Pre-wash. Special functions: Delay start (1-24 hours), Child lock (hold buttons for 3 seconds), Drum clean cycle.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Utilities</h2>
<p>Water: Hot and cold inlet hoses. Drain: Hose to standpipe. Power: Grounded outlet.</p>
<ol>
<li>Turn off water supply and power before connecting.</li>
<li>Match hoses to correct valves (blue for cold, red for hot).</li>
<li>Ensure drain hose is not kinked and positioned correctly.</li>
<li>Plug into dedicated outlet; avoid extension cords.</li>
</ol>
<p><strong>Tip:</strong> Check for leaks after first connection by running a short cycle.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash & Dry Programs</h2>
<p>Supports combined wash+dry cycles or separate functions.</p>
<ol>
<li>Load laundry: Open door, load items evenly, close securely.</li>
<li>Add detergent: Pour into correct drawer compartment.</li>
<li>Select program: Turn dial to desired program (e.g., COTTON).</li>
<li>Adjust settings: Set temperature, spin speed, extra options.</li>
<li>Start cycle: Press Start/Pause; machine will lock door and begin.</li>
<li>Drying: Select drying program after wash or use combined cycle.</li>
<li>End of cycle: Machine beeps; wait for door lock to release before opening.</li>
<li>Clean filter: Regularly clean lint filter after drying cycles.</li>
</ol>
<p><strong>WARNING!</strong> Do not overload drum; follow load capacity guidelines. Remove all objects from pockets.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Safety Features</h2>
<p>Child Lock: Prevents program changes during operation. Door Lock: Automatically locks during cycles. Overheat Protection: Cuts power if temperature exceeds safe limits. Imbalance Detection: Stops spin if load is uneven.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug before cleaning. Wipe exterior with damp cloth; clean detergent drawer monthly; run drum clean cycle every 30 washes.</p>
<p><strong>CAUTION!</strong> Do not use abrasive cleaners; keep control panel dry.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked; complies with EU safety and efficiency standards. Copyright © 2025 Beko; trademarks of Beko PLC. For support, visit www.beko.com or contact customer service at 1-800-000-0000.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Power/door</td><td>Check power connection; ensure door is closed properly.</td></tr>
<tr><td>No water intake</td><td>Taps/hoses</td><td>Ensure water taps are open; check hose for kinks.</td></tr>
<tr><td>Excessive vibration</td><td>Leveling/load</td><td>Re-level machine; redistribute load evenly.</td></tr>
<tr><td>Water not draining</td><td>Drain hose/filter</td><td>Check drain hose for blockages; clean filter.</td></tr>
<tr><td>Drying not effective</td><td>Load/ventilation</td><td>Do not overload; ensure room is ventilated.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart.</p>
<p><strong>Service:</strong> 1-800-000-0000; www.beko.com</p>
<div style="text-align: center;">
Beko Washer Dryer User Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
