<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Beko Washing Machine Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Beko Washing Machine Manual</h1>
<p>The Beko washing machine is a reliable and efficient household appliance designed for various fabric types and load sizes. It features multiple wash programs, energy-saving options, child lock, delay start, and spin speed adjustments. Below are key sections for safety, features, installation, setup, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water Supply</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Special Functions</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Control panel with digital display, detergent drawer, drum, door lock, water inlet valves, drain pump, and adjustable feet.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Wash Programs</td><td>Cotton, Synthetics, Delicates, Quick Wash, Wool, etc.</td></tr>
<tr><td>Spin Speed</td><td>Adjustable up to 1400 RPM</td></tr>
<tr><td>Energy Class</td><td>A+++ for high efficiency</td></tr>
<tr><td>Load Capacity</td><td>Up to 9 kg (varies by model)</td></tr>
<tr><td>Delay Start</td><td>Program start delay up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Noise Level</td><td>Low noise operation</td></tr>
<tr><td>Display</td><td>LED digital display with time remaining</td></tr>
<tr><td>Water Inlet</td><td>Hot & cold water connections</td></tr>
<tr><td>Drain Hose</td><td>Adjustable height for proper drainage</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on level, solid floor.</p>
<ol>
<li>Remove transit bolts: Use spanner to remove bolts at rear; keep for future moves.</li>
<li>Adjust feet: Turn feet to level machine; use spirit level to check.</li>
<li>Connect water supply: Attach hoses to hot/cold taps; ensure washers are fitted.</li>
<li>Connect drain hose: Place hose in standpipe or sink; secure to avoid slipping.</li>
<li>Plug into grounded power outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in areas with freezing temperatures. Ensure water connections are tight to prevent leaks.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Before first wash, run a maintenance cycle.</p>
<ol>
<li>Power on machine: Press POWER button.</li>
<li>Select program: Choose Cotton 90°C without laundry.</li>
<li>Add detergent: Pour 100ml of detergent into drawer compartment II.</li>
<li>Start cycle: Press START/PAUSE to begin; this cleans drum and removes residues.</li>
<li>Set preferences: Use SETTINGS button to adjust beep volume, language, etc.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure transit bolts are removed before first use to prevent damage.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Model Series:</strong> Beko Washing Machine (various models).</li>
<li><strong>Capacity:</strong> 7 kg, 8 kg, 9 kg options.</li>
<li><strong>Spin Speed:</strong> Up to 1400 RPM.</li>
<li><strong>Energy Rating:</strong> A+++ (most efficient).</li>
<li><strong>Water Pressure:</strong> Minimum 0.5 bar, maximum 10 bar.</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50Hz.</li>
<li><strong>Dimensions (HxWxD):</strong> Approx. 85cm x 60cm x 55cm.</li>
<li><strong>Programs:</strong> 15+ programs including Eco, Anti-Allergy, Steam.</li>
<li><strong>Noise Level (wash/spin):</strong> 56 dB / 76 dB.</li>
<li><strong>Warranty:</strong> 2 years parts and labor.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Control Panel: POWER, START/PAUSE, PROGRAM SELECTOR knob, OPTION buttons (e.g., Prewash, Extra Rinse), SPIN SPEED button, TEMPERATURE button, DELAY START button.</p>
<p><strong>Display Symbols:</strong> Door locked, child lock, water tap, drain, cycle progress.</p>
<p>Program Selection: Turn knob to desired program (Cotton, Synthetics, Delicates, etc.). Options: Adjust spin speed (400-1400 RPM or No Spin), temperature (cold to 90°C), extra functions. Settings Menu: Press and hold SETTINGS to access language, volume, factory reset.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water Supply</h2>
<p>Hot and cold water inlets at rear; drain hose connection.</p>
<ol>
<li>Ensure water taps are off before connecting hoses.</li>
<li>Connect blue hose to cold tap, red hose to hot tap (if available).</li>
<li>Use supplied washers; tighten by hand, then a quarter turn with pliers.</li>
<li>Place drain hose in standpipe (min. 60cm height) or over sink edge.</li>
<li>Secure hose with clip to prevent movement.</li>
</ol>
<p><strong>Tip:</strong> Check for leaks after connections; run a short test cycle.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Select program based on fabric type and soil level.</p>
<ol>
<li>Load laundry: Do not overload; leave space for movement.</li>
<li>Add detergent: Use compartment I for prewash, II for main wash, softener symbol for conditioner.</li>
<li>Close door firmly: Machine will not start if door is open.</li>
<li>Select program: Turn knob (e.g., Cotton for towels/bedding).</li>
<li>Adjust options: Set temperature, spin speed, extra rinse if needed.</li>
<li>Start: Press START/PAUSE; door locks and cycle begins.</li>
<li>Pause/change: Press START/PAUSE to pause; wait for door lock light to go off before opening.</li>
<li>End of cycle: Signal sounds; door unlocks after a few minutes.</li>
</ol>
<p><strong>WARNING!</strong> Do not open door during high-temperature washes; steam may cause burns.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Special Functions</h2>
<p>Delay Start: Press DELAY button to set start time (1-24 hours). Child Lock: Press and hold CHILD LOCK for 3 seconds to activate/deactivate. Extra Functions: Prewash for heavily soiled items, Extra Rinse for sensitive skin, Speed Wash for small loads.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug before cleaning. Wipe exterior with damp cloth; clean detergent drawer monthly; run drum cleaning cycle every 30 washes.</p>
<p><strong>CAUTION!</strong> Do not use abrasive cleaners; keep control panel dry.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked; complies with EU directives for safety and electromagnetic compatibility. Energy label according to EU regulations. Copyright © Beko plc; trademarks of Arçelik A.Ş. For support, visit www.beko.com or contact local service center.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Door not closed/power</td><td>Close door firmly; check power outlet; ensure child lock is off.</td></tr>
<tr><td>No water intake</td><td>Taps off/hose kinked</td><td>Open water taps; straighten hoses; check water pressure.</td></tr>
<tr><td>Water not draining</td><td>Drain hose blocked</td><td>Check hose for kinks/blockages; clean pump filter.</td></tr>
<tr><td>Excessive vibration</td><td>Transit bolts/leveling</td><td>Ensure transit bolts removed; adjust feet for level.</td></tr>
<tr><td>Error codes (e.g., E01)</td><td>Various faults</td><td>Refer to manual error code list; unplug for 5 minutes, restart.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then restart.</p>
<p><strong>Service:</strong> Contact authorized Beko service; check warranty card.</p>
<div style="text-align: center;">
Beko Washing Machine Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
