<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Frigo Beko ProSmart Inverter Manual</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Frigo Beko ProSmart Inverter Manual</h1>
<p>The Frigo Beko ProSmart Inverter is an energy-efficient refrigerator featuring inverter compressor technology, multi-airflow cooling, LED lighting, adjustable glass shelves, humidity-controlled crispers, frost-free operation, and digital temperature controls. It offers various cooling modes, door alarm, child lock, and holiday settings. Designed for household use with standard voltage requirements. Below are key sections for safety, features, installation, setup, operation, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting to Power</a>
<a href="#section8">7. Using Cooling Modes</a>
<a href="#section9">8. Special Functions</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Inverter compressor, digital control panel, multi-airflow system, LED interior light, adjustable shelves, humidity-controlled crispers, freezer compartment.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Inverter Compressor</td><td>Energy-efficient, variable speed operation for consistent cooling</td></tr>
<tr><td>Multi-Airflow System</td><td>Even air distribution throughout compartments</td></tr>
<tr><td>Digital Control Panel</td><td>Touch controls for temperature and mode settings</td></tr>
<tr><td>LED Interior Lighting</td><td>Bright, energy-saving illumination</td></tr>
<tr><td>Adjustable Glass Shelves</td><td>Flexible storage configuration</td></tr>
<tr><td>Humidity-Controlled Crispers</td><td>Preserves freshness of fruits and vegetables</td></tr>
<tr><td>Frost-Free Operation</td><td>No manual defrosting required</td></tr>
<tr><td>Door Alarm</td><td>Audible alert if door left open</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental setting changes</td></tr>
<tr><td>Holiday Mode</td><td>Energy-saving setting for extended absences</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Position on level floor.</p>
<ol>
<li>Remove packaging: Take off all tapes, foams, and protective covers.</li>
<li>Position refrigerator: Allow minimum clearance (sides 2 inches, back 4 inches, top 1 inch).</li>
<li>Level the unit: Adjust front leveling feet for stability.</li>
<li>Let stand: After transport, let refrigerator stand upright for 4 hours before plugging in.</li>
</ol>
<p><strong>WARNING!</strong> Do not tilt beyond 45 degrees. Ensure proper ventilation space around unit.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Plug into dedicated power outlet; follow initial setup steps.</p>
<ol>
<li>Power on: Plug into grounded outlet; control panel will illuminate.</li>
<li>Set temperatures: Default is 4°C for fridge, -18°C for freezer. Adjust using temperature buttons.</li>
<li>Load items: Allow 24 hours for optimal cooling before loading fully.</li>
<li>Activate features: Enable door alarm, child lock as needed via control panel.</li>
</ol>
<p><strong>CAUTION!</strong> Do not overload shelves. Distribute items evenly for proper airflow.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Capacity:</strong> Varies by model (typically 300-500 liters).</li>
<li><strong>Refrigerant:</strong> R600a (eco-friendly).</li>
<li><strong>Energy Class:</strong> A++ or higher (energy efficient).</li>
<li><strong>Noise Level:</strong> ≤ 40 dB (quiet operation).</li>
<li><strong>Temperature Range:</strong> Fridge: 2°C to 8°C; Freezer: -24°C to -16°C.</li>
<li><strong>Power Supply:</strong> 220-240V AC, 50Hz.</li>
<li><strong>Dimensions:</strong> Standard household refrigerator size.</li>
<li><strong>Weight:</strong> Varies by model.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Access settings via digital control panel. Buttons: POWER, TEMP (fridge/freezer), MODE, LOCK, ALARM.</p>
<p><strong>Display:</strong> Shows current temperatures, active mode, and warning icons.</p>
<p>Temperature Settings: Adjust fridge/freezer independently. Modes: ECO (energy saving), MAX (rapid cooling), VACATION (holiday mode). Features: Child lock (hold LOCK 3 seconds), door alarm (enable/disable), filter reset indicator. Settings: Celsius/Fahrenheit display, alarm volume, brightness control.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting to Power</h2>
<p>Use dedicated grounded outlet. Ensure proper voltage.</p>
<ol>
<li>Check voltage: Match refrigerator requirements (220-240V).</li>
<li>Use dedicated circuit: Avoid sharing with other high-power appliances.</li>
<li>Ground properly: Use three-prong plug; do not remove ground pin.</li>
<li>Power on: Switch on at outlet; refrigerator will start initial cycle.</li>
</ol>
<p><strong>Tip:</strong> Use voltage stabilizer if power fluctuations are common in your area.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Cooling Modes</h2>
<p>Multiple modes for different needs.</p>
<ol>
<li>ECO Mode: Standard energy-saving operation for daily use.</li>
<li>MAX Cooling: Rapid cooling for quick temperature recovery after loading.</li>
<li>Vacation Mode: Maintains safe temperatures while minimizing energy use during absences.</li>
<li>Super Freeze: Rapid freezing for fresh food; automatically switches off after set time.</li>
<li>Super Cool: Rapid cooling in fridge compartment.</li>
</ol>
<p><strong>WARNING!</strong> Do not run MAX cooling continuously for more than 24 hours.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Special Functions</h2>
<p>Door Alarm: Sounds after 3 minutes if door ajar. Child Lock: Prevents accidental setting changes. Filter Indicator: Reminds when to clean air filter. Holiday Mode: Energy-saving setting for extended absences.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug before cleaning interior. Use mild detergent and soft cloth.</p>
<ol>
<li>Exterior: Wipe with damp cloth; dry thoroughly.</li>
<li>Interior: Remove shelves and drawers; wash with mild soapy water.</li>
<li>Condenser coils: Vacuum dust every 6 months (located at back or bottom).</li>
<li>Door seals: Clean with water only; check for proper seal.</li>
</ol>
<p><strong>CAUTION!</strong> Do not use abrasive cleaners, solvents, or steam cleaners.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE certified: Complies with European safety standards. WEEE directive: Contains recyclable materials; dispose properly. Energy labeling: Complies with EU energy efficiency regulations. For support, visit www.beko.com or contact customer service at the number provided in your region.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Refrigerator not cooling</td><td>Power/doors/settings</td><td>Check power connection; ensure doors closed properly; verify temperature settings.</td></tr>
<tr><td>Unusual noise</td><td>Leveling/items touching</td><td>Ensure refrigerator is level; check if items inside are touching walls.</td></tr>
<tr><td>Water leakage</td><td>Drain clogged/ice buildup</td><td>Check drain hole at back of fridge; clear if clogged.</td></tr>
<tr><td>Excessive frost in freezer</td><td>Door seal/door opening</td><td>Check door seal; minimize door opening frequency and duration.</td></tr>
<tr><td>Display not working</td><td>Power/child lock</td><td>Check power supply; disable child lock if activated.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes, then reconnect to reset electronic controls.</p>
<p><strong>Service:</strong> Contact authorized Beko service center; check warranty card for details.</p>
<div style="text-align: center;">
Frigo Beko ProSmart Inverter Manual © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
