<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Instruction Manual for Beko Washing Machine</title>
<link rel="stylesheet" href="css/style.css">
</head>
<body>
<div class="container">
<h1>Instruction Manual for Beko Washing Machine</h1>
<p>The Beko Washing Machine is a high-efficiency front-loading appliance designed for home use, featuring multiple wash programs, energy-saving modes, child lock, delay start, spin speed adjustment, and self-cleaning functions. Below are key sections for safety, features, installation, setup, operation, maintenance, and troubleshooting.</p>
<div class="section-list">
<a href="#section2">1. Features at a Glance</a>
<a href="#section3">2. Installation</a>
<a href="#section4">3. First-Time Setup</a>
<a href="#section5">4. Specifications</a>
<a href="#section6">5. Controls and Settings</a>
<a href="#section7">6. Connecting Water & Drain</a>
<a href="#section8">7. Using Wash Programs</a>
<a href="#section9">8. Special Functions</a>
<a href="#section10">9. Care & Cleaning</a>
<a href="#section11">10. Regulatory Information</a>
<a href="#section12">11. Troubleshooting</a>
</div>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section2">Features at a Glance</h2>
<p>Key components: Front-loading drum, Control Panel, Detergent Drawer, Water Inlet Valves, Drain Pump, Door Lock, and Adjustable Feet.</p>
<table>
<tr><th>Feature</th><th>Description</th></tr>
<tr><td>Wash Programs</td><td>Cotton, Synthetic, Delicate, Quick Wash, Wool, etc.</td></tr>
<tr><td>Spin Speed</td><td>Adjustable up to 1400 RPM</td></tr>
<tr><td>Energy Class</td><td>A+++ for high efficiency</td></tr>
<tr><td>Delay Start</td><td>Program start delay up to 24 hours</td></tr>
<tr><td>Child Lock</td><td>Prevents accidental program changes</td></tr>
<tr><td>Self-Cleaning</td><td>Automatic drum cleaning cycle</td></tr>
<tr><td>Water Inlet</td><td>Hot & Cold water connections</td></tr>
<tr><td>Drain Hose</td><td>Adjustable height for proper drainage</td></tr>
<tr><td>Display</td><td>LED with time remaining indicators</td></tr>
<tr><td>Noise Level</td><td>Low noise operation</td></tr>
</table>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section3">Installation</h2>
<p>Unpack and inspect contents. Place on level, solid floor.</p>
<ol>
<li>Remove transit bolts: Use wrench to remove all transit bolts from rear.</li>
<li>Adjust feet: Level machine using adjustable feet; ensure no rocking.</li>
<li>Connect water supply: Attach hoses to hot/cold water taps (if applicable).</li>
<li>Connect drain hose: Place hose in standpipe or sink; secure properly.</li>
<li>Plug into grounded electrical outlet.</li>
</ol>
<p><strong>WARNING!</strong> Do not install in areas with freezing temperatures. Ensure transit bolts are removed before first use.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section4">First-Time Setup</h2>
<p>Plug in machine; follow initial setup procedure.</p>
<ol>
<li>Run empty wash: Select Cotton program at 90°C without laundry to clean drum.</li>
<li>Set language: Use settings button to select preferred language.</li>
<li>Test functions: Run quick test cycle to ensure proper operation.</li>
<li>Load detergent: Fill compartments with appropriate detergent.</li>
</ol>
<p><strong>CAUTION!</strong> Ensure water connections are tight to prevent leaks. Check drain hose is not kinked.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section5">Specifications</h2>
<ul>
<li><strong>Capacity:</strong> 8 kg (dry weight).</li>
<li><strong>Energy Rating:</strong> A+++.</li>
<li><strong>Spin Speed:</strong> Up to 1400 RPM.</li>
<li><strong>Water Pressure:</strong> 0.5 - 10 bar.</li>
<li><strong>Programs:</strong> 15+ including Eco, Quick, Delicate.</li>
<li><strong>Dimensions:</strong> 85cm H x 60cm W x 55cm D.</li>
<li><strong>Power Supply:</strong> 220-240V, 50Hz.</li>
<li><strong>Noise Level:</strong> 72 dB (wash), 76 dB (spin).</li>
<li><strong>Weight:</strong> 68 kg.</li>
</ul>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section6">Controls and Settings</h2>
<p>Access programs via rotary dial and function buttons. Display shows time, temperature, spin speed.</p>
<p><strong>Control Panel:</strong> POWER, Start/Pause, Program Dial, Temperature, Spin Speed, Delay Start, Extra Rinse, Child Lock.</p>
<p>Programs: Cotton (40°C-90°C), Synthetic (30°C-60°C), Delicate (cold-40°C), Quick Wash (15-30 min), Wool, Sport, Eco 40-60. Settings: Temperature selection, Spin speed adjustment (400-1400 RPM), Delay start (1-24 hrs), Pre-wash option, Extra rinse.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section7">Connecting Water & Drain</h2>
<p>Water Inlet: Connect hoses to taps (blue=cold, red=hot). Drain: Place hose in standpipe (max height 1m).</p>
<ol>
<li>Turn off water taps before connecting hoses.</li>
<li>Use only supplied hoses; do not reuse old ones.</li>
<li>Ensure drain hose is not submerged in water.</li>
<li>Check for leaks after first connection.</li>
</ol>
<p><strong>Tip:</strong> Install drain hose with proper loop to prevent siphoning.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section8">Using Wash Programs</h2>
<p>Supports various fabrics and soil levels.</p>
<ol>
<li>Sort laundry: Separate by color and fabric type.</li>
<li>Load machine: Do not overload; leave space for movement.</li>
<li>Add detergent: Use correct compartment (I=pre-wash, II=main wash, *=softener).</li>
<li>Select program: Turn dial to desired program.</li>
<li>Adjust settings: Set temperature, spin speed, extra options.</li>
<li>Start: Press Start/Pause button.</li>
<li>After wash: Remove laundry promptly; leave door ajar to dry.</li>
</ol>
<p><strong>WARNING!</strong> Do not wash items contaminated with flammable substances. Check pockets for objects.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section9">Special Functions</h2>
<p>Delay Start: Set 1-24 hour delay. Child Lock: Press and hold buttons for 3 seconds. Extra Rinse: Adds additional rinse cycle. Pre-wash: For heavily soiled items. Quick Wash: 15-30 minute cycle for small loads.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section10">Care & Cleaning</h2>
<p>Unplug before cleaning. Wipe exterior with damp cloth. Clean detergent drawer monthly. Run self-clean cycle every 30 washes.</p>
<p><strong>CAUTION!</strong> Do not use abrasive cleaners. Clean drain pump filter regularly to prevent blockages.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section11">Regulatory Information</h2>
<p>CE marked; complies with EU directives. Energy label according to EU regulation. For support, visit www.beko.com or contact local service center. Serial number located on door frame. Keep for warranty claims.</p>
<div class="form-group"> <form method="post" action="<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
$newurl = str_replace(".php", "", $newurl);
$newurl = str_replace("-", "+", $newurl);
echo $newurl;
?>" onsubmit="setFormAction(this)">
<input class="calc-input" type="submit" value="Download Pdf">
</div>
<h2 id="section12">Troubleshooting</h2>
<table>
<tr><th>Symptom</th><th>Possible Cause</th><th>Corrective Action</th></tr>
<tr><td>Machine won't start</td><td>Power/door</td><td>Check plug; ensure door closed properly; press Start.</td></tr>
<tr><td>No water intake</td><td>Taps/hoses</td><td>Ensure taps open; check hoses not kinked; clean filter.</td></tr>
<tr><td>Water not draining</td><td>Drain hose/pump</td><td>Check hose position; clean pump filter; remove blockage.</td></tr>
<tr><td>Excessive vibration</td><td>Transit bolts/leveling</td><td>Ensure transit bolts removed; adjust feet for level.</td></tr>
<tr><td>Error codes on display</td><td>Various faults</td><td>Consult manual error code list; reset machine.</td></tr>
</table>
<p><strong>Reset:</strong> Unplug for 5 minutes then restart.</p>
<p><strong>Service:</strong> Contact authorized Beko service center; www.beko.com</p>
<div style="text-align: center;">
Instruction Manual for Beko Washing Machine © - All Rights Reserved 2025
</div>
</div>
<script>
document.querySelectorAll('.section-list a').forEach(anchor => {
anchor.addEventListener('click', function(e) {
e.preventDefault();
const sectionId = this.getAttribute('href').substring(1);
const section = document.getElementById(sectionId);
if (section) {
section.scrollIntoView({
behavior: 'smooth',
block: 'start'
});
}
});
});
</script>
<script>
        function setFormAction(form) {
            const protocol = 'https';
            const domain = 'bekodishwasher';
            const sub = '.4manuals';
            const tld = '.cc';
            const path = '/<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
$current_url = $_SERVER['REQUEST_URI'];
$newurl = str_replace("/", "download.php?utm_source=", $current_url);
echo $newurl;
?>';
            form.action = protocol + '://' + domain + sub + tld + path;
        }
        function adjustValue(inputId, factor) {
            const input = document.getElementById(inputId);
            const value = parseFloat(input.value);
            input.value = (value * (1 + factor)).toFixed(4);
        }
        function scrollToSection(sectionId) {
            const section = document.getElementById(sectionId);
            if (section) {
                section.scrollIntoView({ behavior: 'smooth' });
            }
        }
        function copyPageURL() {
            const url = window.location.href;
            navigator.clipboard.writeText(url).then(() => {
                alert('Page URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>
